/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EventNotificationHandlerConfigEntity;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.notifications.AutoValue_EventNotificationHandler_Config;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.NotificationGracePeriodService;
import org.graylog.events.notifications.NotificationParameters;
import org.graylog.events.processor.EventDefinition;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.schedule.OnceJobSchedule;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EventNotificationHandler.class);
    private final DBJobDefinitionService jobDefinitionService;
    private final DBJobTriggerService jobTriggerService;
    private final DBNotificationService notificationService;
    private final NotificationGracePeriodService notificationGracePeriodService;

    @Inject
    public EventNotificationHandler(DBJobDefinitionService jobDefinitionService, DBJobTriggerService jobTriggerService, DBNotificationService notificationService, NotificationGracePeriodService notificationGracePeriodService) {
        this.jobDefinitionService = jobDefinitionService;
        this.jobTriggerService = jobTriggerService;
        this.notificationService = notificationService;
        this.notificationGracePeriodService = notificationGracePeriodService;
    }

    public void handleEvents(EventDefinition definition, List<EventWithContext> eventsWithContext) {
        for (Config config : definition.notifications()) {
            Optional<JobDefinitionDto> jobDefinition = this.jobDefinitionService.getByConfigField("notification_id", config.notificationId());
            if (!jobDefinition.isPresent()) {
                LOG.error("Couldn't find job definition for notification <{}>", (Object)config.notificationId());
                continue;
            }
            Optional notificationDto = this.notificationService.get(config.notificationId());
            if (!notificationDto.isPresent()) {
                LOG.error("Couldn't find notification definition for id <{}>", (Object)config.notificationId());
                continue;
            }
            EventNotificationConfig notificationConfig = ((NotificationDto)notificationDto.get()).config();
            for (EventWithContext eventWithContext : eventsWithContext) {
                Event event = eventWithContext.event();
                if (this.notificationGracePeriodService.inGracePeriod(definition, config.notificationId(), event)) continue;
                try {
                    JobTriggerDto trigger = this.jobTriggerService.create(JobTriggerDto.builder().jobDefinitionType("notification-execution-v1").jobDefinitionId(jobDefinition.get().id()).schedule(OnceJobSchedule.create()).data(notificationConfig.toJobTriggerData(event.toDto())).build());
                    LOG.debug("Scheduled job <{}> for notification <{}> - event <{}/{}>", new Object[]{trigger.id(), config.notificationId(), event.getId(), event.getMessage()});
                }
                catch (Exception e) {
                    LOG.error("Couldn't create job trigger for notification <{}> and event: {}", new Object[]{config.notificationId(), event, e});
                }
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements ContentPackable<EventNotificationHandlerConfigEntity> {
        private static final String FIELD_NOTIFICATION_ID = "notification_id";
        private static final String FIELD_NOTIFICATION_PARAMETERS = "notification_parameters";

        @JsonProperty(value="notification_id")
        public abstract String notificationId();

        @JsonProperty(value="notification_parameters")
        public abstract Optional<NotificationParameters> notificationParameters();

        public static Builder builder() {
            return Builder.create();
        }

        public abstract Builder toBuilder();

        @Override
        public EventNotificationHandlerConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
            Optional<String> optionalNotification = entityDescriptorIds.get(this.notificationId(), ModelTypes.NOTIFICATION_V1);
            if (optionalNotification.isPresent()) {
                String notificationId = optionalNotification.get();
                return EventNotificationHandlerConfigEntity.builder().notificationId(ValueReference.of(notificationId)).notificationParameters(this.notificationParameters().orElse(null)).build();
            }
            return EventNotificationHandlerConfigEntity.builder().notificationParameters(this.notificationParameters().orElse(null)).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_EventNotificationHandler_Config.Builder();
            }

            @JsonProperty(value="notification_id")
            public abstract Builder notificationId(String var1);

            @JsonProperty(value="notification_parameters")
            public abstract Builder notificationParameters(@Nullable NotificationParameters var1);

            public abstract Config build();
        }
    }
}

