/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.ipfix.codecs;

import com.google.common.base.MoreObjects;
import java.net.SocketAddress;
import java.util.Objects;

public class TemplateKey {
    private final SocketAddress remoteAddress;
    private final long observationDomainId;
    private final int templateId;

    public static TemplateKey idForExporter(SocketAddress remoteAddress, long observationDomainId) {
        return new TemplateKey(remoteAddress, observationDomainId, -1);
    }

    public TemplateKey(SocketAddress remoteAddress, long observationDomainId, int templateId) {
        this.remoteAddress = remoteAddress;
        this.observationDomainId = observationDomainId;
        this.templateId = templateId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateKey that = (TemplateKey)o;
        return this.observationDomainId == that.observationDomainId && this.templateId == that.templateId && Objects.equals(this.remoteAddress, that.remoteAddress);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public long getObservationDomainId() {
        return this.observationDomainId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public int hashCode() {
        return Objects.hash(this.remoteAddress, this.observationDomainId, this.templateId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("remoteAddress", (Object)this.remoteAddress).add("observationDomainId", this.observationDomainId).add("templateId", this.templateId).toString();
    }
}

