/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast;

import java.util.Collection;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.RuleAstListener;
import org.graylog.plugins.pipelineprocessor.ast.expressions.AdditionExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.AndExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ArrayLiteralExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BinaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanValuedFunctionWrapper;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ComparisonExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ConstantExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.DoubleExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.EqualityExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FieldAccessExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FieldRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FunctionExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.IndexedAccessExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LongExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MapLiteralExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MessageRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MultiplicationExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NotExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NumericExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.OrExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.SignedExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.StringExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.UnaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.VarRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.statements.FunctionStatement;
import org.graylog.plugins.pipelineprocessor.ast.statements.Statement;
import org.graylog.plugins.pipelineprocessor.ast.statements.VarAssignStatement;

public class RuleAstWalker {
    public void walk(RuleAstListener listener, Rule rule) {
        listener.enterRule(rule);
        listener.enterWhen(rule);
        this.walkExpression(listener, rule.when());
        listener.exitWhen(rule);
        listener.enterThen(rule);
        this.walkStatements(listener, rule.then());
        listener.exitThen(rule);
        listener.exitRule(rule);
    }

    private void walkExpression(RuleAstListener listener, Expression expr) {
        listener.enterEveryExpression(expr);
        this.triggerAbstractEnter(listener, expr);
        switch (expr.nodeType()) {
            case ADD: {
                listener.enterAddition((AdditionExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitAddition((AdditionExpression)expr);
                break;
            }
            case AND: {
                listener.enterAnd((AndExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitAnd((AndExpression)expr);
                break;
            }
            case ARRAY_LITERAL: {
                listener.enterArrayLiteral((ArrayLiteralExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitArrayLiteral((ArrayLiteralExpression)expr);
                break;
            }
            case BINARY: {
                break;
            }
            case BOOLEAN: {
                listener.enterBoolean((BooleanExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitBoolean((BooleanExpression)expr);
                break;
            }
            case BOOLEAN_FUNC_WRAPPER: {
                listener.enterBooleanFuncWrapper((BooleanValuedFunctionWrapper)expr);
                this.visitChildren(listener, expr);
                listener.exitBooleanFuncWrapper((BooleanValuedFunctionWrapper)expr);
                break;
            }
            case COMPARISON: {
                listener.enterComparison((ComparisonExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitComparison((ComparisonExpression)expr);
                break;
            }
            case CONSTANT: {
                break;
            }
            case DOUBLE: {
                listener.enterDouble((DoubleExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitDouble((DoubleExpression)expr);
                break;
            }
            case EQUALITY: {
                listener.enterEquality((EqualityExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitEquality((EqualityExpression)expr);
                break;
            }
            case FIELD_ACCESS: {
                listener.enterFieldAccess((FieldAccessExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitFieldAccess((FieldAccessExpression)expr);
                break;
            }
            case FIELD_REF: {
                listener.enterFieldRef((FieldRefExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitFieldRef((FieldRefExpression)expr);
                break;
            }
            case FUNCTION: {
                listener.enterFunctionCall((FunctionExpression)expr);
                expr.children().forEach(expression -> {
                    listener.enterFunctionArg((FunctionExpression)expr, (Expression)expression);
                    this.walkExpression(listener, (Expression)expression);
                    listener.exitFunctionArg((Expression)expression);
                });
                listener.exitFunctionCall((FunctionExpression)expr);
                break;
            }
            case INDEXED_ACCESS: {
                listener.enterIndexedAccess((IndexedAccessExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitIndexedAccess((IndexedAccessExpression)expr);
                break;
            }
            case LOGICAL: {
                break;
            }
            case LONG: {
                listener.enterLong((LongExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitLong((LongExpression)expr);
                break;
            }
            case MAP_LITERAL: {
                listener.enterMapLiteral((MapLiteralExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitMapLiteral((MapLiteralExpression)expr);
                break;
            }
            case MESSAGE: {
                listener.enterMessageRef((MessageRefExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitMessageRef((MessageRefExpression)expr);
                break;
            }
            case MULT: {
                listener.enterMultiplication((MultiplicationExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitMultiplication((MultiplicationExpression)expr);
                break;
            }
            case NOT: {
                listener.enterNot((NotExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitNot((NotExpression)expr);
                break;
            }
            case NUMERIC: {
                break;
            }
            case OR: {
                listener.enterOr((OrExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitOr((OrExpression)expr);
                break;
            }
            case SIGNED: {
                listener.enterSigned((SignedExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitSigned((SignedExpression)expr);
                break;
            }
            case STRING: {
                listener.enterString((StringExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitString((StringExpression)expr);
                break;
            }
            case UNARY: {
                break;
            }
            case VAR_REF: {
                listener.enterVariableReference((VarRefExpression)expr);
                this.visitChildren(listener, expr);
                listener.exitVariableReference((VarRefExpression)expr);
            }
        }
        this.triggerAbstractExit(listener, expr);
        listener.exitEveryExpression(expr);
    }

    private void triggerAbstractEnter(RuleAstListener listener, Expression expr) {
        if (expr instanceof BinaryExpression) {
            listener.enterBinary((BinaryExpression)expr);
        } else if (expr instanceof UnaryExpression) {
            listener.enterUnary((UnaryExpression)expr);
        }
        if (expr instanceof LogicalExpression) {
            listener.enterLogical((LogicalExpression)expr);
        }
        if (expr instanceof NumericExpression) {
            listener.enterNumeric((NumericExpression)expr);
        }
        if (expr instanceof ConstantExpression) {
            listener.enterConstant((ConstantExpression)expr);
        }
    }

    private void triggerAbstractExit(RuleAstListener listener, Expression expr) {
        if (expr instanceof BinaryExpression) {
            listener.exitBinary((BinaryExpression)expr);
        } else if (expr instanceof UnaryExpression) {
            listener.exitUnary((UnaryExpression)expr);
        }
        if (expr instanceof LogicalExpression) {
            listener.exitLogical((LogicalExpression)expr);
        }
        if (expr instanceof NumericExpression) {
            listener.exitNumeric((NumericExpression)expr);
        }
        if (expr instanceof ConstantExpression) {
            listener.exitConstant((ConstantExpression)expr);
        }
    }

    private void visitChildren(RuleAstListener listener, Expression expr) {
        expr.children().forEach(expression -> this.walkExpression(listener, (Expression)expression));
    }

    private void walkStatements(RuleAstListener listener, Collection<Statement> statements) {
        statements.forEach(statement -> {
            listener.enterStatement((Statement)statement);
            if (statement instanceof FunctionStatement) {
                FunctionStatement func = (FunctionStatement)statement;
                listener.enterFunctionCallStatement(func);
                this.walkExpression(listener, func.getFunctionExpression());
                listener.exitFunctionCallStatement(func);
            } else if (statement instanceof VarAssignStatement) {
                VarAssignStatement assign = (VarAssignStatement)statement;
                listener.enterVariableAssignStatement(assign);
                this.walkExpression(listener, assign.getValueExpression());
                listener.exitVariableAssignStatement(assign);
            }
            listener.exitStatement((Statement)statement);
        });
    }
}

