/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.memory;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.events.PipelinesChangedEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBQuery;

public class InMemoryPipelineService
implements PipelineService {
    private final AtomicLong idGen = new AtomicLong(0L);
    private final Map<String, PipelineDao> store = new ConcurrentHashMap<String, PipelineDao>();
    private final Map<String, String> titleToId = new ConcurrentHashMap<String, String>();
    private final ClusterEventBus clusterBus;

    @Inject
    public InMemoryPipelineService(ClusterEventBus clusterBus) {
        this.clusterBus = clusterBus;
    }

    @Override
    public PipelineDao save(PipelineDao pipeline) {
        PipelineDao toSave;
        PipelineDao pipelineDao = toSave = pipeline.id() != null ? pipeline : pipeline.toBuilder().id(this.createId()).build();
        if (this.titleToId.containsKey(toSave.title()) && !this.titleToId.get(toSave.title()).equals(toSave.id())) {
            throw new IllegalArgumentException("Duplicate pipeline titles are not allowed: " + toSave.title());
        }
        this.titleToId.put(toSave.title(), toSave.id());
        this.store.put(toSave.id(), toSave);
        this.clusterBus.post(PipelinesChangedEvent.updatedPipelineId(toSave.id()));
        return toSave;
    }

    @Override
    public PipelineDao load(String id) throws NotFoundException {
        PipelineDao pipeline = this.store.get(id);
        if (pipeline == null) {
            throw new NotFoundException("No such pipeline with id " + id);
        }
        return pipeline;
    }

    @Override
    public PipelineDao loadByName(String name) throws NotFoundException {
        String id = this.titleToId.get(name);
        if (id == null) {
            throw new NotFoundException("No pipeline with name " + name);
        }
        return this.load(id);
    }

    @Override
    public Collection<PipelineDao> loadAll() {
        return ImmutableSet.copyOf(this.store.values());
    }

    @Override
    public void delete(String id) {
        if (id == null) {
            return;
        }
        PipelineDao removed = this.store.remove(id);
        if (removed != null) {
            this.titleToId.remove(removed.title());
        }
        this.clusterBus.post(PipelinesChangedEvent.deletedPipelineId(id));
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }

    @Override
    public long count(DBQuery.Query query) {
        return this.store.size();
    }
}

