/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.bson.conversions.Bson;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.events.PipelineConnectionsChangedEvent;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class MongoDbPipelineStreamConnectionsService
implements PipelineStreamConnectionsService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDbPipelineStreamConnectionsService.class);
    private static final String COLLECTION = "pipeline_processor_pipelines_streams";
    private final JacksonDBCollection<PipelineConnections, String> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    public MongoDbPipelineStreamConnectionsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION), PipelineConnections.class, String.class, mapper.get());
        this.clusterBus = clusterBus;
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"stream_id"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public PipelineConnections save(PipelineConnections connections) {
        PipelineConnections existingConnections = this.dbCollection.findOne((Bson)DBQuery.is((String)"stream_id", (Object)connections.streamId()));
        if (existingConnections == null) {
            existingConnections = PipelineConnections.create(null, connections.streamId(), Collections.emptySet());
        }
        PipelineConnections toSave = existingConnections.toBuilder().pipelineIds(connections.pipelineIds()).build();
        WriteResult<PipelineConnections, String> save = this.dbCollection.save(toSave);
        PipelineConnections savedConnections = save.getSavedObject();
        this.clusterBus.post(PipelineConnectionsChangedEvent.create(savedConnections.streamId(), savedConnections.pipelineIds()));
        return savedConnections;
    }

    @Override
    public PipelineConnections load(String streamId) throws NotFoundException {
        PipelineConnections oneById = this.dbCollection.findOne((Bson)DBQuery.is((String)"stream_id", (Object)streamId));
        if (oneById == null) {
            throw new NotFoundException("No pipeline connections with for stream " + streamId);
        }
        return oneById;
    }

    @Override
    public Set<PipelineConnections> loadAll() {
        DBCursor<PipelineConnections> connections = this.dbCollection.find();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(connections);
            if (connections != null) {
                connections.close();
            }
            return immutableSet;
        }
        catch (Throwable throwable) {
            try {
                if (connections != null) {
                    try {
                        connections.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MongoException e) {
                log.error("Unable to load pipeline connections", (Throwable)e);
                return Collections.emptySet();
            }
        }
    }

    @Override
    public Set<PipelineConnections> loadByPipelineId(String pipelineId) {
        BasicDBObject query = new BasicDBObject("pipeline_ids", (Object)new BasicDBObject("$in", Collections.singleton(pipelineId)));
        DBCursor<PipelineConnections> pipelineConnections = this.dbCollection.find((DBObject)query);
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(pipelineConnections);
            if (pipelineConnections != null) {
                pipelineConnections.close();
            }
            return immutableSet;
        }
        catch (Throwable throwable) {
            try {
                if (pipelineConnections != null) {
                    try {
                        pipelineConnections.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MongoException e) {
                log.error("Unable to load pipeline connections for pipeline ID " + pipelineId, (Throwable)e);
                return Collections.emptySet();
            }
        }
    }

    @Override
    public void delete(String streamId) {
        try {
            PipelineConnections connections = this.load(streamId);
            Set<String> pipelineIds = connections.pipelineIds();
            this.dbCollection.removeById(connections.id());
            this.clusterBus.post(PipelineConnectionsChangedEvent.create(streamId, pipelineIds));
        }
        catch (NotFoundException e) {
            log.debug("No connections found for stream " + streamId);
        }
    }
}

