/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import au.com.bytecode.opencsv.CSVParser;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvMapConversion
extends AbstractFunction<Map> {
    private final Logger log = LoggerFactory.getLogger(CsvMapConversion.class);
    public static final String NAME = "csv_to_map";
    private static final String VALUE = "value";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("Map-like value to convert").build();
    private final ParameterDescriptor<String, String> fieldsParam = ParameterDescriptor.string("fieldNames").description("List of field names separated by the <separator> character").build();
    private final ParameterDescriptor<String, Character> separatorParam = ParameterDescriptor.string("separator", Character.class).optional().transform(this::getFirstChar).description("Character to split lines by, will be shortened to first character (default is <,>)").defaultValue(Optional.of(String.valueOf(','))).build();
    private final ParameterDescriptor<String, Character> quoteCharParam = ParameterDescriptor.string("quoteChar", Character.class).optional().transform(this::getFirstChar).description("Character used to quote fields (default is <\">)").defaultValue(Optional.of(String.valueOf('\"'))).build();
    private final ParameterDescriptor<String, Character> escapeCharParam = ParameterDescriptor.string("escapeChar", Character.class).optional().transform(this::getFirstChar).description("Character used to escape the separator and quote characters (default is <\\>)").defaultValue(Optional.of(String.valueOf('\\'))).build();
    private final ParameterDescriptor<Boolean, Boolean> strictQuotesParam = ParameterDescriptor.bool("strictQuotes").optional().description("Ignore content outside of quotes").defaultValue(Optional.of(false)).build();
    private final ParameterDescriptor<Boolean, Boolean> trimParam = ParameterDescriptor.bool("trimLeadingWhitespace").optional().description("Trim leading whitespace").defaultValue(Optional.of(false)).build();

    private Character getFirstChar(String s) {
        if (!Strings.isNullOrEmpty((String)s)) {
            return Character.valueOf(s.charAt(0));
        }
        return null;
    }

    @Override
    public Map evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        String fields = this.fieldsParam.required(args, context);
        Character separator = this.separatorParam.optional(args, context).orElse(Character.valueOf(','));
        Character quoteChar = this.quoteCharParam.optional(args, context).orElse(Character.valueOf('\"'));
        Character escapeChar = this.escapeCharParam.optional(args, context).orElse(Character.valueOf('\\'));
        boolean strictQuotes = this.strictQuotesParam.optional(args, context).orElse(false);
        boolean trimLeadingWhiteSpace = this.trimParam.optional(args, context).orElse(true);
        CSVParser parser = new CSVParser(separator.charValue(), quoteChar.charValue(), escapeChar.charValue(), strictQuotes, trimLeadingWhiteSpace);
        try {
            String[] fieldNames = parser.parseLine(fields);
            if (fieldNames.length == 0) {
                this.log.error("No field names found");
                return Collections.emptyMap();
            }
            HashMap map = Maps.newHashMap();
            try {
                String[] strings = parser.parseLine(value);
                if (strings.length != fieldNames.length) {
                    this.log.error("Different number of columns in CSV data ({}) and configured field names ({}). Discarding input.", (Object)strings.length, (Object)fieldNames.length);
                    return Collections.emptyMap();
                }
                for (int i = 0; i < strings.length; ++i) {
                    map.put(fieldNames[i], strings[i]);
                }
            }
            catch (IOException e) {
                this.log.error("Invalid CSV input, discarding input", (Throwable)e);
                return Collections.emptyMap();
            }
            return map;
        }
        catch (IOException e) {
            this.log.error("Error parsing csv", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    @Override
    public FunctionDescriptor<Map> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Map.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.fieldsParam, this.separatorParam, this.quoteCharParam, this.escapeCharParam, this.strictQuotesParam, this.trimParam)).description("Converts a single line of a CSV string into a map usable by set_fields()").ruleBuilderEnabled().ruleBuilderName("Convert CSV to map").ruleBuilderTitle("Convert CSV string '${value}' to map").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.CONVERSION).build();
    }
}

