/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.maps;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class MapSet
extends AbstractFunction<Map> {
    public static final String NAME = "map_set";
    private static final String MAPARG = "map";
    private static final String KEYARG = "key";
    private static final String VALUEARG = "value";
    private final ParameterDescriptor<Map, Map> mapParam = ParameterDescriptor.type("map", Map.class).ruleBuilderVariable().description("A map").build();
    private final ParameterDescriptor<String, String> keyParam = ParameterDescriptor.string("key").description("Set this key in map").build();
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("New value").build();

    @Override
    public Map evaluate(FunctionArgs args, EvaluationContext context) {
        Map mapValue = this.mapParam.required(args, context);
        String keyValue = this.keyParam.required(args, context);
        Object valueValue = this.valueParam.required(args, context);
        if (mapValue == null || Strings.isNullOrEmpty((String)keyValue)) {
            return mapValue;
        }
        mapValue.put(keyValue, valueValue);
        return mapValue;
    }

    @Override
    public FunctionDescriptor<Map> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Map.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.mapParam, this.keyParam, this.valueParam)).description("Set a key in the map").ruleBuilderEnabled().ruleBuilderName("Set key in map").ruleBuilderTitle("Update '${key}' in map").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build();
    }
}

