/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.Message;

public class RemoveField
extends AbstractFunction<Void> {
    public static final String NAME = "remove_field";
    public static final String FIELD = "field";
    public static final String INVERT = "invert";
    private final ParameterDescriptor<String, Pattern> fieldParam = ParameterDescriptor.string("field", Pattern.class).transform(Pattern::compile).description("The field(s) to remove (name or regex)").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();
    private final ParameterDescriptor<Boolean, Boolean> invertParam = ParameterDescriptor.bool("invert").optional().description("Invert: keep matching field(s) and remove all others").build();

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Pattern pattern = this.fieldParam.required(args, context);
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Boolean invert = this.invertParam.optional(args, context).orElse(false);
        message.getFieldNames().stream().filter(f -> {
            boolean condition = pattern.matcher((CharSequence)f).matches();
            return invert.booleanValue() ? !condition : condition;
        }).collect(Collectors.toList()).forEach(message::removeField);
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.fieldParam, this.messageParam, this.invertParam)).description("Removes the named field from message, unless the field is reserved. If no specific message is provided, it uses the currently processed message. This function is deprecated - use the more performant remove_single_field or remove_multiple_fields.").ruleBuilderEnabled().ruleBuilderName("Remove field (deprecated)").ruleBuilderTitle("Remove field '${field}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.MESSAGE).build();
    }
}

