/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.action;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidationResult;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.Validator;
import org.graylog2.shared.utilities.StringUtils;

public class ValidVariables
implements Validator {
    private final Map<String, RuleFragment> actions;
    private Map<String, Class<?>> variables;

    @Inject
    public ValidVariables(RuleBuilderRegistry ruleBuilderRegistry) {
        this.actions = ruleBuilderRegistry.actions();
        this.variables = new HashMap();
    }

    @Override
    public ValidationResult validate(RuleBuilderStep step) {
        RuleFragment ruleFragment = this.actions.get(step.function());
        FunctionDescriptor functionDescriptor = ruleFragment.descriptor();
        Map<String, Object> stepParameters = step.parameters();
        String outputvariable = step.outputvariable();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)outputvariable)) {
            if (functionDescriptor.returnType() == Void.class) {
                return new ValidationResult(true, StringUtils.f("Return type is void. No output variable allowed", functionDescriptor.name()));
            }
            this.storeVariable(outputvariable, functionDescriptor.returnType());
        }
        ImmutableList<ParameterDescriptor> parameterDescriptors = functionDescriptor.params();
        for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
            String s;
            String parameterName = parameterDescriptor.name();
            Object value = stepParameters.get(parameterName);
            Class<?> variableType = this.getVariableType(value);
            if (!parameterDescriptor.optional() && value == null) {
                return new ValidationResult(true, StringUtils.f("Missing parameter %s", parameterName));
            }
            if (value instanceof String && (s = (String)value).startsWith("$")) {
                String substring = s.substring(1);
                Class<?> passedVariableType = this.variables.get(substring);
                if (Objects.isNull(passedVariableType)) {
                    return new ValidationResult(true, StringUtils.f("Could not find passed variable %s", value));
                }
                variableType = passedVariableType;
            }
            Class paramType = parameterDescriptor.type();
            if (value == null || paramType == Object.class || variableType == paramType) continue;
            String errorMsg = "Found a wrong parameter type for parameter %s";
            return new ValidationResult(true, StringUtils.f(errorMsg, parameterName));
        }
        return new ValidationResult(false, "");
    }

    private void storeVariable(String name, Class<?> type) {
        this.variables.put(name, type);
    }

    private Class<?> getVariableType(Object type) {
        if (type instanceof Double) {
            return Double.class;
        }
        if (type instanceof Integer) {
            return Long.class;
        }
        if (type instanceof Long) {
            return Long.class;
        }
        if (type instanceof String) {
            return String.class;
        }
        if (type instanceof Boolean) {
            return Boolean.class;
        }
        return Object.class;
    }
}

