/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.ConfigurationVariable;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.ConfigurationVariableService;
import org.graylog.plugins.sidecar.services.EtagService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Sidecar/ConfigurationVariables", description="Manage collector configuration variables", tags={"cloud"})
@Path(value="/sidecar/configuration_variables")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class ConfigurationVariableResource
extends RestResource
implements PluginRestResource {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    private static final Pattern INVALID_NAME_PREFIX = Pattern.compile("^[0-9].*");
    private final ConfigurationVariableService configurationVariableService;
    private final ConfigurationService configurationService;
    private final EtagService etagService;

    @Inject
    public ConfigurationVariableResource(ConfigurationVariableService configurationVariableService, ConfigurationService configurationService, EtagService etagService) {
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
        this.etagService = etagService;
    }

    @GET
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all configuration variables")
    public List<ConfigurationVariable> listConfigurationVariables() {
        List<ConfigurationVariable> configurationVariables = this.configurationVariableService.all();
        return configurationVariables;
    }

    @GET
    @Path(value="/{id}/configurations")
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show configurations using this variable")
    public List<Configuration> getConfigurationVariablesConfigurations(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        ConfigurationVariable configurationVariable = this.findVariableOrFail(id);
        List<Configuration> configurations = this.configurationService.findByConfigurationVariable(configurationVariable);
        return configurations;
    }

    @POST
    @RequiresPermissions(value={"sidecar_collector_configurations:create"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new configuration variable")
    @AuditEvent(type="sidecar:configuration_variable:create")
    public Response createConfigurationVariable(@ApiParam(name="JSON body", required=true) @Valid @NotNull ConfigurationVariable request) {
        ValidationResult validationResult = this.validateConfigurationVariableHelper(request);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        ConfigurationVariable configurationVariable = this.persistConfigurationVariable(null, request);
        return Response.ok().entity((Object)configurationVariable).build();
    }

    @PUT
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecar_collector_configurations:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a configuration variable")
    @AuditEvent(type="sidecar:configuration_variable:update")
    public Response updateConfigurationVariable(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull ConfigurationVariable request) {
        ConfigurationVariable previousConfigurationVariable = this.findVariableOrFail(id);
        ValidationResult validationResult = this.validateConfigurationVariableHelper(request);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        if (!previousConfigurationVariable.name().equals(request.name())) {
            this.configurationService.replaceVariableNames(previousConfigurationVariable.fullName(), request.fullName());
        }
        ConfigurationVariable updatedConfigurationVariable = this.persistConfigurationVariable(id, request);
        this.etagService.invalidateAllConfigurations();
        return Response.ok().entity((Object)updatedConfigurationVariable).build();
    }

    @POST
    @Path(value="/validate")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate a configuration variable")
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    public ValidationResult validateConfigurationVariable(@ApiParam(name="JSON body", required=true) @Valid @NotNull ConfigurationVariable toValidate) {
        return this.validateConfigurationVariableHelper(toValidate);
    }

    @DELETE
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecar_collector_configurations:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a configuration variable")
    @AuditEvent(type="sidecar:configuration_variable:delete")
    public Response deleteConfigurationVariable(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        ConfigurationVariable configurationVariable = this.findVariableOrFail(id);
        List<Configuration> configurations = this.configurationService.findByConfigurationVariable(configurationVariable);
        if (!configurations.isEmpty()) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError("name", "Variable is still used in the following configurations: " + configurations.stream().map(c -> c.name()).collect(Collectors.joining(", ")));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        int deleted = this.configurationVariableService.delete(id);
        if (deleted == 0) {
            return Response.notModified().build();
        }
        this.etagService.invalidateAllConfigurations();
        return Response.accepted().build();
    }

    private ValidationResult validateConfigurationVariableHelper(ConfigurationVariable confVar) {
        ValidationResult validationResult = new ValidationResult();
        if (confVar.name().isEmpty()) {
            validationResult.addError("name", "Variable name can not be empty.");
        } else if (!VALID_NAME_PATTERN.matcher(confVar.name()).matches()) {
            validationResult.addError("name", "Variable name can only contain the following characters: A-Z,a-z,0-9,_");
        } else if (INVALID_NAME_PREFIX.matcher(confVar.name()).matches()) {
            validationResult.addError("name", "Variable name can not start with numbers.");
        }
        if (this.configurationVariableService.hasConflict(confVar)) {
            validationResult.addError("name", "A variable with that name already exists.");
        }
        if (confVar.content().isEmpty()) {
            validationResult.addError("content", "Variable content can not be empty.");
        }
        return validationResult;
    }

    private ConfigurationVariable findVariableOrFail(String id) {
        ConfigurationVariable configurationVariable = this.configurationVariableService.find(id);
        if (configurationVariable == null) {
            throw new NotFoundException("Could not find ConfigurationVariable <" + id + ">.");
        }
        return configurationVariable;
    }

    private ConfigurationVariable persistConfigurationVariable(String id, ConfigurationVariable request) {
        ConfigurationVariable configurationVariable = id == null ? this.configurationVariableService.fromRequest(request) : this.configurationVariableService.fromRequest(id, request);
        return this.configurationVariableService.save(configurationVariable);
    }
}

