/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.SearchTypeExecutionState;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.events.AutoValue_EventList;
import org.graylog.plugins.views.search.searchtypes.events.AutoValue_EventList_Result;
import org.graylog.plugins.views.search.searchtypes.events.CommonEventSummary;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.EventListEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.database.filtering.AttributeFilter;

@JsonTypeName(value="events")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventList
implements SearchType {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final String NAME = "events";
    public static final Set<String> KNOWN_ATTRIBUTES = Set.of("priority", "event_definition_id", "alert");
    public static final SortConfig DEFAULT_SORT = new SortConfig("timestamp", Direction.DESC);

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @Nullable
    public abstract Filter filter();

    @Override
    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty
    public abstract Optional<Integer> page();

    @JsonProperty
    public abstract Optional<Integer> perPage();

    @JsonProperty
    public abstract List<AttributeFilter> attributes();

    @JsonProperty
    public abstract Optional<SortConfig> sort();

    public SortConfig sortWithDefault() {
        return this.sort().orElse(DEFAULT_SORT);
    }

    @JsonCreator
    public static Builder builder() {
        return new AutoValue_EventList.Builder().type(NAME).filters(Collections.emptyList()).streams(Collections.emptySet()).attributes(Collections.emptyList());
    }

    public abstract Builder toBuilder();

    @Override
    public SearchType applyExecutionContext(SearchTypeExecutionState state) {
        if (state.page().isPresent() || state.perPage().isPresent()) {
            Builder builder = this.toBuilder();
            state.page().ifPresent(builder::page);
            state.perPage().ifPresent(builder::perPage);
            return builder.build();
        }
        return this;
    }

    @Override
    public SearchType withQuery(BackendQuery query) {
        return this.toBuilder().query(query).build();
    }

    @Override
    public SearchType withFilter(Filter filter) {
        return this.toBuilder().filter(filter).build();
    }

    @Override
    public SearchType withFilters(List<UsedSearchFilter> filters) {
        return this.toBuilder().filters(filters).build();
    }

    @Override
    public Set<String> effectiveStreams() {
        return ImmutableSet.of((Object)"000000000000000000000002", (Object)"000000000000000000000003");
    }

    @Override
    public SearchTypeEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return ((EventListEntity.Builder)EventListEntity.builder().streams((Set)this.mappedStreams(entityDescriptorIds))).filter(this.filter()).filters(this.filters()).id(this.id()).name(this.name().orElse(null)).query(this.query().orElse(null)).type(this.type()).timerange(this.timerange().orElse(null)).build();
    }

    public record SortConfig(@JsonProperty(value="field") String field, @JsonProperty(value="direction") Direction direction) {
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder createDefault() {
            return EventList.builder().filters(Collections.emptyList()).streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(String var1);

        abstract String id();

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty(value="filters")
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @JsonProperty
        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @JsonProperty
        public abstract Builder page(@Nullable Integer var1);

        abstract Optional<Integer> page();

        @JsonProperty
        public abstract Builder perPage(@Nullable Integer var1);

        abstract Optional<Integer> perPage();

        @JsonProperty
        public abstract Builder attributes(List<AttributeFilter> var1);

        abstract List<AttributeFilter> attributes();

        @JsonProperty
        public abstract Builder sort(@Nullable SortConfig var1);

        abstract EventList autoBuild();

        public EventList build() {
            if (this.id() == null) {
                this.id(UUID.randomUUID().toString());
            }
            Preconditions.checkArgument((this.page().orElse(1) > 0 ? 1 : 0) != 0, (Object)"Page needs to be a positive, non-zero value");
            Preconditions.checkArgument((this.perPage().orElse(1) > 0 ? 1 : 0) != 0, (Object)"Per page needs to be a positive, non-zero value");
            return this.autoBuild();
        }
    }

    public static enum Direction {
        ASC,
        DESC;

    }

    @JsonTypeName(value="events")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Result
    implements SearchType.Result {
        @Override
        @JsonProperty
        public abstract String id();

        @Override
        @JsonProperty
        public abstract String type();

        @JsonProperty
        public abstract List<CommonEventSummary> events();

        @JsonProperty
        public abstract long totalResults();

        public static Builder builder() {
            return new AutoValue_EventList_Result.Builder().type(EventList.NAME);
        }

        abstract Builder toBuilder();

        public Result withEvents(List<CommonEventSummary> events, long totalResults) {
            return this.toBuilder().events(events).totalResults(totalResults).build();
        }

        public static Builder result(String searchTypeId) {
            return Result.builder().id(searchTypeId);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_EventList_Result.Builder().type(EventList.NAME);
            }

            @JsonProperty
            public abstract Builder id(String var1);

            @JsonProperty
            public abstract Builder name(String var1);

            @JsonProperty
            public abstract Builder type(String var1);

            @JsonProperty
            public abstract Builder events(List<CommonEventSummary> var1);

            @JsonProperty
            public abstract Builder totalResults(long var1);

            public abstract Result build();
        }
    }
}

