/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import java.util.List;
import java.util.function.Predicate;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog.plugins.views.search.views.ViewUtils;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class ViewSummaryService
extends PaginatedDbService<ViewSummaryDTO>
implements ViewUtils<ViewSummaryDTO> {
    private static final String COLLECTION_NAME = "views";
    private final MongoCollection<ViewSummaryDTO> collection;

    @Inject
    protected ViewSummaryService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mongoJackObjectMapperProvider, MongoCollections mongoCollections) {
        super(mongoConnection, mongoJackObjectMapperProvider, ViewSummaryDTO.class, COLLECTION_NAME);
        this.collection = mongoCollections.get(COLLECTION_NAME, ViewSummaryDTO.class);
    }

    public PaginatedList<ViewSummaryDTO> searchPaginatedByType(SearchUser searchUser, ViewDTO.Type type, Bson dbQuery, Predicate<ViewSummaryDTO> predicate, String order, String sortField, int page, int perPage) {
        Preconditions.checkNotNull((Object)sortField);
        DBSort.SortBuilder sort = this.getMultiFieldSortBuilder(order, List.of(sortField, "title"));
        Bson query = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"type", (Object)((Object)type)), Filters.exists((String)"type", (boolean)false)}), dbQuery});
        List<ViewSummaryDTO> views = this.findViews(searchUser, query, sort).filter(predicate).toList();
        List<ViewSummaryDTO> paginatedStreams = perPage > 0 ? views.stream().skip((long)perPage * (long)Math.max(0, page - 1)).limit(perPage).toList() : views;
        long grandTotal = this.db.getCount((Bson)DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"type", (Object)((Object)type)), DBQuery.notExists((String)"type")}));
        return new PaginatedList<ViewSummaryDTO>(paginatedStreams, views.size(), page, perPage, grandTotal);
    }

    @Override
    public MongoCollection<ViewSummaryDTO> collection() {
        return this.collection;
    }
}

