/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.storage.migration.RemoteReindexParams;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.datanode.RemoteReindexRequest;
import org.graylog2.indexer.datanode.RemoteReindexingMigrationAdapter;
import org.graylog2.indexer.migration.RemoteReindexMigration;

@Path(value="/remote-reindex-migration")
@RequiresAuthentication
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="ReindexMigration", description="Migrate data from existing cluster")
public class RemoteReindexResource {
    private final RemoteReindexingMigrationAdapter migrationService;

    @Inject
    public RemoteReindexResource(RemoteReindexingMigrationAdapter migrationService) {
        this.migrationService = migrationService;
    }

    @POST
    @Path(value="/remoteReindex")
    @NoAuditEvent(value="No Audit Event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @ApiOperation(value="by remote reindexing", notes="configure the host/credentials you want to use to migrate data from")
    public String migrate(@ApiParam(name="remote configuration") @NotNull @Valid RemoteReindexParams params) {
        RemoteReindexRequest req = new RemoteReindexRequest(params.allowlist(), params.hostname(), params.user(), params.password(), params.indices(), params.threadsCount());
        return this.migrationService.start(req);
    }

    @GET
    @Path(value="/status/{migrationID}")
    @NoAuditEvent(value="No Audit Event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @ApiOperation(value="status", notes="status for a running migration")
    public RemoteReindexMigration status(@ApiParam(name="migrationID") @PathParam(value="migrationID") String migrationID) {
        return this.migrationService.status(migrationID);
    }
}

