/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog2.database.MongoCollections;
import org.graylog2.shared.utilities.StringUtils;

public class DBCustomJobDefinitionService {
    private final MongoCollection<JobDefinitionDto> db;

    @Inject
    public DBCustomJobDefinitionService(MongoCollections collections) {
        this.db = collections.get("scheduler_job_definitions", JobDefinitionDto.class);
    }

    public JobDefinitionDto findOrCreate(JobDefinitionDto dto) {
        ObjectId jobDefinitionId = new ObjectId(Objects.requireNonNull(dto.id(), "Job definition ID cannot be null"));
        Codec codec = this.db.getCodecRegistry().get(JobDefinitionDto.class);
        try (BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());){
            codec.encode((BsonWriter)writer, (Object)dto, EncoderContext.builder().build());
            JobDefinitionDto jobDefinitionDto = (JobDefinitionDto)this.db.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)jobDefinitionId), Filters.eq((String)StringUtils.f("%s.%s", "config", "type"), (Object)dto.config().type())}), Updates.setOnInsert((Bson)writer.getDocument()), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER).upsert(true));
            return jobDefinitionDto;
        }
    }
}

