/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import com.google.auto.value.AutoValue;
import org.graylog.security.authservice.AutoValue_AuthServiceCredentials;
import org.graylog2.security.encryption.EncryptedValue;

@AutoValue
public abstract class AuthServiceCredentials {
    public abstract String username();

    public abstract EncryptedValue password();

    public abstract boolean isAuthenticated();

    public static AuthServiceCredentials create(String username, EncryptedValue password) {
        return AuthServiceCredentials.builder().username(username).password(password).isAuthenticated(false).build();
    }

    public static AuthServiceCredentials createAuthenticated(String username) {
        return AuthServiceCredentials.builder().username(username).password(EncryptedValue.createUnset()).isAuthenticated(true).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public static Builder create() {
            return new AutoValue_AuthServiceCredentials.Builder().isAuthenticated(false);
        }

        public abstract Builder username(String var1);

        public abstract Builder password(EncryptedValue var1);

        public abstract Builder isAuthenticated(boolean var1);

        public abstract AuthServiceCredentials build();
    }
}

