/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog2.bootstrap.CliCommand;
import org.graylog2.plugin.Tools;

@Command(name="cert", description="Manage certificates for data-node", groupNames={"certutil"})
public class CertutilCert
implements CliCommand {
    @Option(name={"--ca"}, description="Filename for the CA keystore")
    protected String caKeystoreFilename = "datanode-ca.p12";
    @Option(name={"--keystore"}, description="Filename for the generated keystore")
    protected String nodeKeystoreFilename = "datanode-transport-certificates.p12";
    private final CommandLineConsole console;
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CA_PASSWORD = CommandLineConsole.prompt("Enter CA password: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CERT_ALTERNATIVE_NAMES = CommandLineConsole.prompt("Enter alternative names (addresses) of this node [comma separated]: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CERTIFICATE_PASSWORD = CommandLineConsole.prompt("Enter datanode certificate password: ");

    public CertutilCert() {
        this.console = new SystemConsole();
    }

    public CertutilCert(String caKeystoreFilename, String nodeKeystoreFilename, CommandLineConsole console) {
        this.caKeystoreFilename = caKeystoreFilename;
        this.nodeKeystoreFilename = nodeKeystoreFilename;
        this.console = console;
    }

    @Override
    public void run() {
        this.console.printLine("This tool will generate a data-node certificate signed by provided certificate authority");
        Path caKeystorePath = Path.of(this.caKeystoreFilename, new String[0]);
        this.console.printLine("Using certificate authority " + caKeystorePath.toAbsolutePath());
        try {
            char[] password = this.console.readPassword(PROMPT_ENTER_CA_PASSWORD);
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(new FileInputStream(caKeystorePath.toFile()), password);
            Key caPrivateKey = caKeystore.getKey("ca", password);
            X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
            this.console.printLine("Successfully read CA from the keystore");
            KeyPair caPair = new KeyPair((PrivateKey)caPrivateKey, null, caCertificate);
            this.console.printLine("Generating private key and certificate for this datanode");
            CertRequest req = CertRequest.signed(Tools.getLocalCanonicalHostname(), caPair).withSubjectAlternativeName("localhost").withSubjectAlternativeName(Tools.getLocalHostname()).withSubjectAlternativeName(String.valueOf(InetAddress.getLocalHost())).withSubjectAlternativeName("127.0.0.1").withSubjectAlternativeName("ip6-localhost").validity(Duration.ofDays(3650L));
            String alternativeNames = this.console.readLine(PROMPT_ENTER_CERT_ALTERNATIVE_NAMES);
            Arrays.stream(alternativeNames.split(",")).filter(StringUtils::isNotBlank).forEach(req::withSubjectAlternativeName);
            KeyPair nodePair = CertificateGenerator.generate(req);
            KeyStore nodeKeystore = KeyStore.getInstance("PKCS12");
            nodeKeystore.load(null, null);
            char[] nodeKeystorePassword = this.console.readPassword(PROMPT_ENTER_CERTIFICATE_PASSWORD);
            nodeKeystore.setKeyEntry("datanode", nodePair.privateKey(), nodeKeystorePassword, new X509Certificate[]{nodePair.certificate(), caPair.certificate()});
            Path nodeKeystorePath = Path.of(this.nodeKeystoreFilename, new String[0]);
            try (FileOutputStream store = new FileOutputStream(nodeKeystorePath.toFile());){
                nodeKeystore.store(store, nodeKeystorePassword);
                this.console.printLine("Private key and certificate for this datanode successfully saved into " + nodeKeystorePath.toAbsolutePath());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

