/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import jakarta.inject.Inject;
import java.net.URI;
import java.util.List;
import org.graylog2.bootstrap.preflight.PreflightCheck;
import org.graylog2.bootstrap.preflight.PreflightCheckException;
import org.graylog2.configuration.IndexerHosts;
import org.graylog2.configuration.validators.ElasticsearchVersionValidator;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.versionprobe.ElasticsearchProbeException;
import org.graylog2.storage.versionprobe.VersionProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDbPreflightCheck
implements PreflightCheck {
    private static final Logger LOG = LoggerFactory.getLogger(SearchDbPreflightCheck.class);
    private final VersionProbe elasticVersionProbe;
    private final List<URI> elasticsearchHosts;

    @Inject
    public SearchDbPreflightCheck(VersionProbe elasticVersionProbe, @IndexerHosts List<URI> elasticsearchHosts) {
        this.elasticVersionProbe = elasticVersionProbe;
        this.elasticsearchHosts = elasticsearchHosts;
    }

    @Override
    public void runCheck() throws PreflightCheckException {
        try {
            SearchVersion searchVersion = this.elasticVersionProbe.probe(this.elasticsearchHosts).orElseThrow(() -> new PreflightCheckException("Could not get Elasticsearch version"));
            if (ElasticsearchVersionValidator.SUPPORTED_ES_VERSIONS.stream().noneMatch(searchVersion::satisfies)) {
                throw new PreflightCheckException(StringUtils.f("Unsupported (Elastic/Open)Search version <%s>. Supported versions: <%s>", searchVersion, ElasticsearchVersionValidator.SUPPORTED_ES_VERSIONS));
            }
            LOG.info("Connected to (Elastic/Open)Search version <{}>", (Object)searchVersion);
        }
        catch (ElasticsearchProbeException e) {
            throw new PreflightCheckException(e);
        }
    }
}

