/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.model.CA;
import org.graylog2.bootstrap.preflight.web.resources.model.CertParameters;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateCARequest;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.ApiError;

@Path(value="/api/")
@Produces(value={"application/json"})
public class PreflightResource {
    private final NodeService<DataNodeDto> nodeService;
    private final DataNodeProvisioningService dataNodeProvisioningService;
    private final CaService caService;
    private final ClusterConfigService clusterConfigService;
    private final String passwordSecret;

    @Inject
    public PreflightResource(NodeService<DataNodeDto> nodeService, DataNodeProvisioningService dataNodeProvisioningService, CaService caService, ClusterConfigService clusterConfigService, @Named(value="password_secret") String passwordSecret) {
        this.nodeService = nodeService;
        this.dataNodeProvisioningService = dataNodeProvisioningService;
        this.caService = caService;
        this.clusterConfigService = clusterConfigService;
        this.passwordSecret = passwordSecret;
    }

    @GET
    @Path(value="/data_nodes")
    public List<DataNode> listDataNodes() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        Map preflightDataNodes = this.dataNodeProvisioningService.streamAll().collect(Collectors.toMap(DataNodeProvisioningConfig::nodeId, Function.identity()));
        return activeDataNodes.values().stream().map(n -> {
            DataNodeProvisioningConfig preflight = (DataNodeProvisioningConfig)preflightDataNodes.get(n.getNodeId());
            return new DataNode(n.getNodeId(), n.getTransportAddress(), preflight != null ? preflight.state() : null, preflight != null ? preflight.errorMsg() : null, n.getHostname(), n.getShortNodeId());
        }).collect(Collectors.toList());
    }

    @GET
    @Path(value="/ca")
    public CA get() throws KeyStoreStorageException {
        return this.caService.get();
    }

    @POST
    @Path(value="/ca/create")
    @NoAuditEvent(value="No Audit Event needed")
    public void createCA(@NotNull @Valid CreateCARequest request) throws CACreationException, KeyStoreStorageException, KeyStoreException, NoSuchAlgorithmException {
        this.caService.create(request.organization(), 3650, this.passwordSecret.toCharArray());
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/ca/upload")
    @NoAuditEvent(value="No Audit Event needed")
    public Response uploadCA(@FormDataParam(value="password") String password, @FormDataParam(value="files") List<FormDataBodyPart> bodyParts) {
        try {
            this.caService.upload(password, bodyParts);
            return Response.ok().build();
        }
        catch (CACreationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/startOver")
    @NoAuditEvent(value="No Audit Event needed")
    public void startOver() {
        this.caService.startOver();
        this.clusterConfigService.remove(RenewalPolicy.class);
        this.dataNodeProvisioningService.deleteAll();
    }

    @DELETE
    @Path(value="/startOver/{nodeID}")
    @NoAuditEvent(value="No Audit Event needed")
    public void startOver(@PathParam(value="nodeID") String nodeID) {
        this.dataNodeProvisioningService.delete(nodeID);
    }

    @POST
    @Path(value="/generate")
    @NoAuditEvent(value="No Audit Event needed")
    public void generate() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        activeDataNodes.values().forEach(node -> this.dataNodeProvisioningService.changeState(node.getNodeId(), DataNodeProvisioningConfig.State.CONFIGURED));
    }

    @POST
    @Path(value="/{nodeID}")
    @Consumes(value={"application/json"})
    @NoAuditEvent(value="No Audit Event needed")
    public void addParameters(@PathParam(value="nodeID") String nodeID, @NotNull CertParameters params) {
        Optional<DataNodeProvisioningConfig> cfg = this.dataNodeProvisioningService.getPreflightConfigFor(nodeID);
        DataNodeProvisioningConfig.Builder builder = cfg.map(DataNodeProvisioningConfig::toBuilder).orElse(DataNodeProvisioningConfig.builder().nodeId(nodeID));
        builder.altNames(params.altNames()).validFor(params.validFor());
        this.dataNodeProvisioningService.save(builder.build());
    }

    record DataNode(String nodeId, String transportAddress, DataNodeProvisioningConfig.State status, String errorMsg, String hostname, String shortNodeId) {
    }
}

