/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.suggestions;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.AllPermission;
import org.apache.shiro.subject.Subject;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.dbcatalog.DbEntitiesCatalog;
import org.graylog2.database.dbcatalog.DbEntityCatalogEntry;
import org.graylog2.database.suggestions.EntitySuggestion;
import org.graylog2.database.suggestions.EntitySuggestionResponse;
import org.graylog2.database.suggestions.EntitySuggestionService;

public class MongoEntitySuggestionService
implements EntitySuggestionService {
    private final MongoConnection mongoConnection;
    private final DbEntitiesCatalog catalog;

    @Inject
    public MongoEntitySuggestionService(MongoConnection mongoConnection, DbEntitiesCatalog catalog) {
        this.mongoConnection = mongoConnection;
        this.catalog = catalog;
    }

    @Override
    public EntitySuggestionResponse suggest(String collection, String valueColumn, String query, int page, int perPage, Subject subject) {
        if (!this.hasAllPermission(subject) && !this.hasReadPermissionForWholeCollection(subject, collection)) {
            return new EntitySuggestionResponse(List.of(), PaginatedList.PaginationInfo.create(0, 0, page, perPage));
        }
        MongoCollection mongoCollection = this.mongoConnection.getMongoDatabase().getCollection(collection);
        BsonDocument bsonFilter = query != null && !query.isEmpty() ? Filters.regex((String)valueColumn, (String)query, (String)"i") : new BsonDocument();
        FindIterable documents = mongoCollection.find((Bson)bsonFilter).projection(Projections.include((String[])new String[]{valueColumn})).sort(Sorts.ascending((String[])new String[]{valueColumn})).limit(perPage).skip((page - 1) * perPage);
        List suggestions = (List)documents.map(doc -> new EntitySuggestion(doc.getObjectId((Object)"_id").toString(), doc.getString((Object)valueColumn))).into(new ArrayList());
        long total = mongoCollection.countDocuments((Bson)bsonFilter);
        return new EntitySuggestionResponse(suggestions, PaginatedList.PaginationInfo.create((int)total, suggestions.size(), page, perPage));
    }

    boolean hasAllPermission(Subject subject) {
        return subject.isPermitted((Permission)new AllPermission());
    }

    boolean hasReadPermissionForWholeCollection(Subject subject, String collection) {
        return this.catalog.getByCollectionName(collection).map(DbEntityCatalogEntry::readPermission).map(rp -> rp.equals("") || subject.isPermitted(rp + ":*")).orElse(false);
    }
}

