/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.datanode;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.datanode.DataNodeLifecycleEvent;
import org.graylog2.datanode.DataNodeLifecycleTrigger;
import org.graylog2.datanode.DataNodeService;
import org.graylog2.events.ClusterEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOG = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    private final ClusterEventBus clusterEventBus;
    private final NodeService<DataNodeDto> nodeService;

    @Inject
    public DataNodeServiceImpl(ClusterEventBus clusterEventBus, NodeService<DataNodeDto> nodeService, EventBus eventBus) {
        this.clusterEventBus = clusterEventBus;
        this.nodeService = nodeService;
        eventBus.register((Object)this);
    }

    @Override
    public DataNodeDto removeNode(String nodeId) throws NodeNotFoundException {
        DataNodeDto node = this.nodeService.byNodeId(nodeId);
        if (node.getDataNodeStatus() != DataNodeStatus.AVAILABLE) {
            throw new IllegalArgumentException("Only running data nodes can be removed from the cluster.");
        }
        if (this.nodeService.allActive().values().stream().filter(n -> n.getDataNodeStatus() == DataNodeStatus.AVAILABLE && n.getActionQueue() == null).count() <= 1L) {
            throw new IllegalArgumentException("Cannot remove last data node in the cluster.");
        }
        DataNodeLifecycleTrigger trigger = DataNodeLifecycleTrigger.REMOVE;
        DataNodeStatus lockingStatus = DataNodeStatus.REMOVING;
        this.addToQueue(node, trigger, lockingStatus);
        return node;
    }

    @Override
    public DataNodeDto resetNode(String nodeId) throws NodeNotFoundException {
        DataNodeDto node = this.nodeService.byNodeId(nodeId);
        if (node.getDataNodeStatus() != DataNodeStatus.REMOVED) {
            throw new IllegalArgumentException("Only previously removed data nodes can rejoin the cluster.");
        }
        DataNodeLifecycleEvent e = DataNodeLifecycleEvent.create(node.getNodeId(), DataNodeLifecycleTrigger.RESET);
        this.clusterEventBus.post(e);
        return node;
    }

    @Override
    public DataNodeDto stopNode(String nodeId) throws NodeNotFoundException {
        DataNodeDto node = this.nodeService.byNodeId(nodeId);
        if (node.getDataNodeStatus() != DataNodeStatus.AVAILABLE) {
            throw new IllegalArgumentException("Only running data nodes can be stopped.");
        }
        DataNodeLifecycleEvent e = DataNodeLifecycleEvent.create(node.getNodeId(), DataNodeLifecycleTrigger.STOP);
        this.clusterEventBus.post(e);
        return node;
    }

    @Override
    public DataNodeDto startNode(String nodeId) throws NodeNotFoundException {
        DataNodeDto node = this.nodeService.byNodeId(nodeId);
        if (node.getDataNodeStatus() != DataNodeStatus.UNAVAILABLE) {
            throw new IllegalArgumentException("Only stopped data nodes can be started.");
        }
        DataNodeLifecycleEvent e = DataNodeLifecycleEvent.create(node.getNodeId(), DataNodeLifecycleTrigger.START);
        this.clusterEventBus.post(e);
        return node;
    }

    private void addToQueue(DataNodeDto node, DataNodeLifecycleTrigger trigger, DataNodeStatus lockingStatus) {
        this.nodeService.update(node.toBuilder().setActionQueue(trigger).build());
        if (!this.otherNodeHasStatus(node.getNodeId(), lockingStatus, trigger)) {
            DataNodeLifecycleEvent e = DataNodeLifecycleEvent.create(node.getNodeId(), trigger);
            this.clusterEventBus.post(e);
        }
    }

    private boolean otherNodeHasStatus(String nodeId, DataNodeStatus status, DataNodeLifecycleTrigger trigger) {
        return this.nodeService.allActive().values().stream().anyMatch(n -> !n.getNodeId().equals(nodeId) && (n.getDataNodeStatus() == status || n.getActionQueue() == trigger));
    }

    @Subscribe
    public void handleDataNodeLifeCycleEvent(DataNodeLifecycleEvent event) {
        switch (event.trigger()) {
            case REMOVED: {
                this.handleNextNode(DataNodeLifecycleTrigger.REMOVE);
                break;
            }
            case STOPPED: {
                this.handleNextNode(DataNodeLifecycleTrigger.STOP);
            }
        }
    }

    private void handleNextNode(DataNodeLifecycleTrigger trigger) {
        this.nodeService.allActive().values().stream().filter(node -> node.getActionQueue() == trigger).findFirst().ifPresent(node -> this.clusterEventBus.post(DataNodeLifecycleEvent.create(node.getNodeId(), trigger)));
    }
}

