/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.filtering.inmemory.InMemoryFilterExpressionParser;
import org.graylog2.database.filtering.inmemory.InMemoryFilterable;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.indexer.fieldtypes.utils.FieldTypeDTOsMerger;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileService;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldType;
import org.jetbrains.annotations.NotNull;

public class IndexFieldTypesListService {
    private final IndexFieldTypesService indexFieldTypesService;
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory indexSetFactory;
    private final IndexFieldTypeProfileService profileService;
    private final InMemoryFilterExpressionParser inMemoryFilterExpressionParser;
    private final FieldTypeDTOsMerger fieldTypeDTOsMerger;

    @Inject
    public IndexFieldTypesListService(IndexFieldTypesService indexFieldTypesService, IndexSetService indexSetService, MongoIndexSet.Factory indexSetFactory, FieldTypeDTOsMerger fieldTypeDTOsMerger, InMemoryFilterExpressionParser inMemoryFilterExpressionParser, IndexFieldTypeProfileService profileService) {
        this.indexFieldTypesService = indexFieldTypesService;
        this.indexSetService = indexSetService;
        this.indexSetFactory = indexSetFactory;
        this.fieldTypeDTOsMerger = fieldTypeDTOsMerger;
        this.inMemoryFilterExpressionParser = inMemoryFilterExpressionParser;
        this.profileService = profileService;
    }

    public PageListResponse<IndexSetFieldType> getIndexSetFieldTypesListPage(String indexSetId, String fieldNameQuery, List<String> filters, int page, int perPage, String sort, Sorting.Direction order) {
        List<IndexSetFieldType> filteredFields = this.getFilteredList(indexSetId, fieldNameQuery, filters, sort, order);
        int total = filteredFields.size();
        List retrievedPage = filteredFields.stream().skip((long)Math.max(0, page - 1) * (long)perPage).limit(perPage).toList();
        return PageListResponse.create("", PaginatedList.PaginationInfo.create(total, retrievedPage.size(), page, perPage), total, sort, order.toString().toLowerCase(Locale.ROOT), retrievedPage, IndexSetFieldType.ATTRIBUTES, IndexSetFieldType.ENTITY_DEFAULTS);
    }

    public List<IndexSetFieldType> getIndexSetFieldTypesList(String indexSetId, String fieldNameQuery, List<String> filters, String sort, Sorting.Direction order) {
        return this.getFilteredList(indexSetId, fieldNameQuery, filters, sort, order);
    }

    public Map<String, List<IndexSetFieldType>> getIndexSetFieldTypesList(Set<String> indexSetId, Collection<String> fieldNameQuery) {
        return this.getFilteredList(indexSetId, fieldNameQuery);
    }

    @NotNull
    private List<IndexSetFieldType> getFilteredList(String indexSetId, String fieldNameQuery, List<String> filters, String sort, Sorting.Direction order) {
        Optional<IndexSetConfig> indexSetConfig = this.indexSetService.get(indexSetId);
        Optional<IndexSet> mongoIndexSet = indexSetConfig.map(this.indexSetFactory::create);
        CustomFieldMappings customFieldMappings = indexSetConfig.map(IndexSetConfig::customFieldMappings).orElse(new CustomFieldMappings());
        Optional fieldTypeProfile = indexSetConfig.map(IndexSetConfig::fieldTypeProfile).filter(ObjectId::isValid).flatMap(this.profileService::get);
        Set deflectorFieldDtos = (Set)mongoIndexSet.map(IndexSet::getActiveWriteIndex).map(this.indexFieldTypesService::findOneByIndexName).map(IndexFieldTypesDTO::fields).orElse(ImmutableSet.of());
        Set previousFieldDtos = (Set)mongoIndexSet.map(this::getPreviousActiveIndexSet).map(this.indexFieldTypesService::findOneByIndexName).map(IndexFieldTypesDTO::fields).orElse(ImmutableSet.of());
        Collection<IndexSetFieldType> allFields = this.fieldTypeDTOsMerger.merge(deflectorFieldDtos, previousFieldDtos, customFieldMappings, fieldTypeProfile.orElse(null));
        return allFields.stream().filter(indexSetFieldType -> indexSetFieldType.fieldName().contains(fieldNameQuery)).filter(indexSetFieldType -> this.inMemoryFilterExpressionParser.parse(filters, IndexSetFieldType.ATTRIBUTES).test((InMemoryFilterable)indexSetFieldType)).sorted(IndexSetFieldType.getComparator(sort, order)).toList();
    }

    @NotNull
    private Map<String, List<IndexSetFieldType>> getFilteredList(Set<String> indexSetIds, Collection<String> fieldNames) {
        List<IndexSetConfig> indexSetConfigs = this.indexSetService.findByIds(indexSetIds);
        Map<String, MongoIndexSet> mongoIndexSets = indexSetConfigs.stream().collect(Collectors.toMap(IndexSetConfig::id, this.indexSetFactory::create));
        Set activeWriteIndices = mongoIndexSets.values().stream().map(MongoIndexSet::getActiveWriteIndex).collect(Collectors.toSet());
        Set previousActiveIndexSets = mongoIndexSets.values().stream().map(this::getPreviousActiveIndexSet).collect(Collectors.toSet());
        Map indexFieldTypes = this.indexFieldTypesService.findByIndexNames((Collection<String>)Sets.union(activeWriteIndices, previousActiveIndexSets)).stream().collect(Collectors.toMap(IndexFieldTypesDTO::indexName, Function.identity()));
        return indexSetConfigs.stream().collect(Collectors.toMap(IndexSetConfig::id, indexSetConfig -> {
            MongoIndexSet mongoIndexSet = this.indexSetFactory.create((IndexSetConfig)indexSetConfig);
            CustomFieldMappings customFieldMappings = indexSetConfig.customFieldMappings();
            Optional fieldTypeProfile = Optional.ofNullable(indexSetConfig.fieldTypeProfile()).flatMap(this.profileService::get);
            Set deflectorFieldDtos = (Set)Optional.ofNullable((IndexFieldTypesDTO)indexFieldTypes.get(mongoIndexSet.getActiveWriteIndex())).map(IndexFieldTypesDTO::fields).orElse(ImmutableSet.of());
            Set previousFieldDtos = (Set)Optional.ofNullable((IndexFieldTypesDTO)indexFieldTypes.get(this.getPreviousActiveIndexSet(mongoIndexSet))).map(IndexFieldTypesDTO::fields).orElse(ImmutableSet.of());
            Collection<IndexSetFieldType> allFields = this.fieldTypeDTOsMerger.merge(deflectorFieldDtos, previousFieldDtos, customFieldMappings, fieldTypeProfile.orElse(null));
            return allFields.stream().filter(indexSetFieldType -> fieldNames.contains(indexSetFieldType.fieldName())).toList();
        }));
    }

    private String getPreviousActiveIndexSet(IndexSet indexSet) {
        return indexSet.getNthIndexBeforeActiveIndexSet(1);
    }
}

