/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.migration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jsonwebtoken.lang.Collections;
import jakarta.validation.constraints.NotNull;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graylog2.indexer.datanode.RemoteReindexingMigrationAdapter;
import org.graylog2.indexer.migration.LogEntry;
import org.graylog2.indexer.migration.RemoteReindexIndex;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RemoteReindexMigration {
    @JsonProperty(value="id")
    private final String id;
    private final List<RemoteReindexIndex> indices;
    private final List<LogEntry> logs;
    @JsonProperty(value="error")
    private String error;

    public RemoteReindexMigration(@NotNull String migrationID, List<RemoteReindexIndex> indices, List<LogEntry> logs) {
        this.id = migrationID;
        this.indices = indices;
        this.logs = logs;
    }

    public static RemoteReindexMigration nonExistent(String migrationID) {
        return new RemoteReindexMigration(migrationID, Collections.emptyList(), Collections.emptyList());
    }

    @JsonProperty(value="indices")
    public List<RemoteReindexIndex> indices() {
        return this.indices;
    }

    public String id() {
        return this.id;
    }

    @JsonProperty(value="status")
    public RemoteReindexingMigrationAdapter.Status status() {
        if (this.indices.isEmpty()) {
            return RemoteReindexingMigrationAdapter.Status.NOT_STARTED;
        }
        if (this.indices().stream().map(RemoteReindexIndex::status).anyMatch(i -> i == RemoteReindexingMigrationAdapter.Status.RUNNING)) {
            return RemoteReindexingMigrationAdapter.Status.RUNNING;
        }
        if (this.indices().stream().map(RemoteReindexIndex::status).anyMatch(i -> i == RemoteReindexingMigrationAdapter.Status.ERROR)) {
            return RemoteReindexingMigrationAdapter.Status.ERROR;
        }
        return RemoteReindexingMigrationAdapter.Status.FINISHED;
    }

    @JsonProperty(value="progress")
    public int progress() {
        if (this.indices.isEmpty()) {
            return 100;
        }
        double indexPortion = 100.0 / (double)this.indices.size();
        double overallProgress = this.indices.stream().filter(i -> i.progress() != null).mapToDouble(i -> (double)i.progress().progressPercent() / 100.0).map(relativeProgress -> relativeProgress * indexPortion).sum();
        return Math.min((int)Math.ceil(overallProgress), 100);
    }

    public List<LogEntry> getLogs() {
        return Optional.ofNullable(this.logs).map(l -> l.stream().toList()).orElse(Collections.emptyList());
    }

    @JsonProperty(value="tasks_progress")
    public Map<String, Integer> getTasksProgress() {
        return this.indices.stream().filter(i -> i.status() == RemoteReindexingMigrationAdapter.Status.RUNNING).filter(i -> i.progress() != null).sorted(Comparator.comparing(RemoteReindexIndex::name)).collect(Collectors.toMap(RemoteReindexIndex::name, i -> i.progress().progressPercent(), (integer, integer2) -> integer, LinkedHashMap::new));
    }
}

