/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.codecs;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodec
implements Codec {
    private static final Logger log = LoggerFactory.getLogger(AbstractCodec.class);
    protected final Configuration configuration;
    protected final Charset charset;
    private String name;

    protected AbstractCodec(Configuration configuration) {
        this.configuration = configuration;
        this.charset = configuration.stringIsSet("charset_name") ? Charset.forName(configuration.getString("charset_name")) : StandardCharsets.UTF_8;
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.getClass().isAnnotationPresent(org.graylog2.plugin.inputs.annotations.Codec.class)) {
                this.name = this.getClass().getAnnotation(org.graylog2.plugin.inputs.annotations.Codec.class).name();
            } else {
                log.error("Annotation {} missing on codec {}. This is a bug and this codec will not be available.", org.graylog2.plugin.inputs.annotations.Codec.class, this.getClass());
            }
        }
        return this.name;
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    public static class Descriptor
    extends Codec.Descriptor {
        public Descriptor(String name) {
            super(name);
        }
    }

    public static abstract class Config
    implements Codec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configurationRequest = new ConfigurationRequest();
            configurationRequest.addField(new TextField("override_source", "Override source", null, "The source is a hostname derived from the received packet by default. Set this if you want to override it with a custom string.", ConfigurationField.Optional.OPTIONAL));
            configurationRequest.addField(new TextField("charset_name", "Encoding", StandardCharsets.UTF_8.name(), "Default encoding is UTF-8. Set this to a standard charset name if you want override the default.", ConfigurationField.Optional.OPTIONAL));
            return configurationRequest;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }
}

