/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteDeflectorResource;

@RequiresAuthentication
@Api(value="Cluster/Deflector", description="Cluster-wide deflector handling", tags={"cloud"})
@Path(value="/cluster/deflector")
@Produces(value={"application/json"})
public class ClusterDeflectorResource
extends ProxiedResource {
    @Inject
    public ClusterDeflectorResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @POST
    @Timed
    @ApiOperation(value="Finds leader node and triggers deflector cycle")
    @Path(value="/cycle")
    @NoAuditEvent(value="this is a proxy resource, the event will be triggered on the individual nodes")
    public void cycle() throws IOException {
        this.requestOnLeader(RemoteDeflectorResource::cycle, RemoteDeflectorResource.class);
    }

    @POST
    @Timed
    @ApiOperation(value="Finds leader node and triggers deflector cycle")
    @Path(value="/{indexSetId}/cycle")
    @NoAuditEvent(value="this is a proxy resource, the event will be triggered on the individual nodes")
    public void cycle(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) throws IOException {
        this.requestOnLeader(c -> c.cycleIndexSet(indexSetId), RemoteDeflectorResource.class);
    }
}

