/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indices;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.StringSchema;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.rest.models.system.indices.RetentionStrategies;
import org.graylog2.rest.models.system.indices.RetentionStrategyDescription;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/Indices/Retention", description="Index retention strategy settings", tags={"cloud"})
@Path(value="/system/indices/retention")
@Produces(value={"application/json"})
@RequiresAuthentication
public class RetentionStrategyResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RetentionStrategyResource.class);
    private final Map<String, Provider<RetentionStrategy>> retentionStrategies;
    private final ObjectMapper objectMapper;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public RetentionStrategyResource(Map<String, Provider<RetentionStrategy>> retentionStrategies, ObjectMapper objectMapper, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.retentionStrategies = Objects.requireNonNull(retentionStrategies);
        this.objectMapper = objectMapper;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    @GET
    @Path(value="strategies")
    @Timed
    @ApiOperation(value="List available retention strategies", notes="This resource returns a list of all available retention strategies on this Graylog node.")
    public RetentionStrategies list() {
        Set<RetentionStrategyDescription> strategies = this.retentionStrategies.keySet().stream().map(this::getRetentionStrategyDescription).collect(Collectors.toSet());
        RetentionStrategies.Context context = RetentionStrategies.Context.create(this.elasticsearchConfiguration.getMaxIndexRetentionPeriod());
        return RetentionStrategies.create(strategies.size(), strategies, context);
    }

    @GET
    @Path(value="strategies/{strategy}")
    @Timed
    @ApiOperation(value="Show JSON schema for configuration of given retention strategies", notes="This resource returns a JSON schema for the configuration of the given retention strategy.")
    public RetentionStrategyDescription configSchema(@ApiParam(name="strategy", value="The name of the retention strategy", required=true) @PathParam(value="strategy") @NotEmpty String strategyName) {
        return this.getRetentionStrategyDescription(strategyName);
    }

    private RetentionStrategyDescription getRetentionStrategyDescription(@ApiParam(name="strategy", value="The name of the retention strategy", required=true) @PathParam(value="strategy") @NotEmpty String strategyName) {
        Provider<RetentionStrategy> provider = this.retentionStrategies.get(strategyName);
        if (provider == null) {
            throw new NotFoundException("Couldn't find retention strategy for given type " + strategyName);
        }
        RetentionStrategy retentionStrategy = (RetentionStrategy)provider.get();
        RetentionStrategyConfig defaultConfig = retentionStrategy.defaultConfiguration();
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        try {
            this.objectMapper.acceptJsonFormatVisitor(this.objectMapper.constructType(retentionStrategy.configurationClass()), (JsonFormatVisitorWrapper)visitor);
        }
        catch (JsonMappingException e) {
            throw new InternalServerErrorException("Couldn't generate JSON schema for retention strategy " + strategyName, (Throwable)e);
        }
        JsonSchema jsonSchema = visitor.finalSchema();
        this.removeDeactivatedStrategiesActions(jsonSchema);
        return RetentionStrategyDescription.create(strategyName, defaultConfig, jsonSchema);
    }

    private void removeDeactivatedStrategiesActions(JsonSchema schema) {
        Map properties = ((ObjectSchema)schema).getProperties();
        JsonSchema indexAction = (JsonSchema)properties.get("index_action");
        if (Objects.nonNull(indexAction)) {
            Set actionEnums = ((StringSchema)indexAction).getEnums();
            Set<String> disabledRetentionStrategies = this.elasticsearchConfiguration.getDisabledRetentionStrategies();
            disabledRetentionStrategies.stream().map(s -> s.toUpperCase(Locale.ENGLISH)).toList().forEach(actionEnums::remove);
        }
    }
}

