/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.glassfish.grizzly.http.server.Response;
import org.graylog2.rest.RestTools;
import org.graylog2.utilities.IpSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAccessLogFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.graylog2.rest.accesslog");
    private final Response response;
    private final Set<IpSubnet> trustedProxies;

    @Inject
    public RestAccessLogFilter(@Context Response response, @Named(value="trusted_proxies") Set<IpSubnet> trustedProxies) {
        this.response = Objects.requireNonNull(response);
        this.trustedProxies = Objects.requireNonNull(trustedProxies);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            try {
                String rawQuery = requestContext.getUriInfo().getRequestUri().getRawQuery();
                Date requestDate = requestContext.getDate();
                String userId = RestTools.getUserIdFromRequest(requestContext);
                String remoteAddress = RestTools.getRemoteAddrFromRequest(this.response.getRequest(), this.trustedProxies);
                String userAgent = requestContext.getHeaderString("User-Agent");
                LOG.debug("{} {} [{}] \"{} {}{}\" {} {} {}", new Object[]{remoteAddress, userId == null ? "-" : userId, requestDate == null ? "-" : requestDate, requestContext.getMethod(), requestContext.getUriInfo().getPath(), rawQuery == null ? "" : "?" + rawQuery, userAgent == null ? "-" : userAgent, responseContext.getStatus(), responseContext.getLength()});
            }
            catch (Exception e) {
                LOG.error("Error while processing REST API access log", (Throwable)e);
            }
        }
    }
}

