/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.exceptionmappers;

import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Collection;
import java.util.Collections;
import org.graylog2.plugin.rest.ApiError;

@Provider
public class JacksonPropertyExceptionMapper
implements ExceptionMapper<PropertyBindingException> {
    public Response toResponse(PropertyBindingException e) {
        Collection knownPropertyIds = (Collection)MoreObjects.firstNonNull((Object)e.getKnownPropertyIds(), Collections.emptyList());
        StringBuilder message = new StringBuilder("Unable to map property ").append(e.getPropertyName()).append(".\nKnown properties include: ");
        Joiner.on((String)", ").appendTo(message, (Iterable)knownPropertyIds);
        ApiError apiError = ApiError.create(message.toString());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)apiError).build();
    }
}

