/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.graylog.security.events.AuthServiceBackendSavedEvent;
import org.graylog2.shared.rest.resources.csp.CSPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CSPEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CSPEventListener.class);
    private final CSPService cspService;

    @Inject
    public CSPEventListener(EventBus eventBus, CSPService cspService) {
        this.cspService = cspService;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleBackendCreated(AuthServiceBackendSavedEvent event) {
        try {
            LOG.debug("Updating CSP for authentication service <{}>", (Object)event.authServiceId());
            this.cspService.updateConnectSrc();
        }
        catch (Exception e) {
            LOG.warn("Failed to update CSP for authentication service <{}>", (Object)event.authServiceId(), (Object)e);
        }
    }
}

