/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.plugin.security.Permission;
import org.graylog2.plugin.security.PluginPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Permissions {
    private static final Logger LOG = LoggerFactory.getLogger(Permissions.class);
    private final Set<String> allPermissions;
    private final Set<String> readerBasePermissions;
    private final Map<String, Collection<String>> allPermissionsMap;

    @Inject
    public Permissions(Set<PluginPermissions> pluginPermissions) {
        this.allPermissions = Permissions.buildPermissions(pluginPermissions, PluginPermissions::permissions);
        this.readerBasePermissions = Permissions.buildPermissions(pluginPermissions, PluginPermissions::readerBasePermissions);
        this.allPermissionsMap = this.buildPermissionsMap(this.allPermissions);
    }

    public Set<String> allPermissions() {
        return this.allPermissions;
    }

    public Map<String, Collection<String>> allPermissionsMap() {
        return this.allPermissionsMap;
    }

    public Set<String> readerBasePermissions() {
        return this.readerBasePermissions;
    }

    public Set<String> readerPermissions(String username) {
        ImmutableSet.Builder perms = ImmutableSet.builder().addAll(this.readerBasePermissions);
        if (Strings.isNullOrEmpty((String)username)) {
            LOG.error("Username cannot be empty or null for creating reader permissions");
            throw new IllegalArgumentException("Username was null or empty when getting reader permissions.");
        }
        perms.addAll(this.userSelfEditPermissions(username));
        return perms.build();
    }

    public Set<String> userSelfEditPermissions(String username) {
        ImmutableSet.Builder perms = ImmutableSet.builder();
        perms.add((Object)this.perInstance("users:edit", username));
        perms.add((Object)this.perInstance("users:passwordchange", username));
        perms.add((Object)this.perInstance("users:tokenlist", username));
        perms.add((Object)this.perInstance("users:tokencreate", username));
        perms.add((Object)this.perInstance("users:tokenremove", username));
        return perms.build();
    }

    private String perInstance(String permission, String instance) {
        return permission + ":" + instance;
    }

    private static Set<String> buildPermissions(Set<PluginPermissions> pluginPermissions, PermissionListCallback callback) {
        HashSet<String> permissionSet = new HashSet<String>();
        for (PluginPermissions pluginPermission : pluginPermissions) {
            for (Permission permission : callback.permissions(pluginPermission)) {
                if (!permissionSet.contains(permission.permission())) {
                    permissionSet.add(permission.permission());
                    continue;
                }
                LOG.error("Error adding permissions for plugin: {}", (Object)pluginPermission.getClass().getCanonicalName());
                throw new IllegalArgumentException("Duplicate permission found. Permission \"" + permission.toString() + "\" already exists!");
            }
        }
        return ImmutableSet.copyOf(permissionSet);
    }

    private Map<String, Collection<String>> buildPermissionsMap(Set<String> permissions) {
        ArrayListMultimap all = ArrayListMultimap.create();
        for (String permission : permissions) {
            Iterator split = Splitter.on((char)':').limit(2).split((CharSequence)permission).iterator();
            String group = (String)split.next();
            String action = (String)split.next();
            all.put((Object)group, (Object)action);
        }
        return ImmutableMap.copyOf(all.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue())))));
    }

    private static interface PermissionListCallback {
        public Set<Permission> permissions(PluginPermissions var1);
    }
}

