/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.processing.control;

import com.github.joschi.jadconfig.util.Duration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.cluster.nodes.ServerNodeDto;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.system.processing.control.ClusterProcessingControl;
import org.graylog2.system.processing.control.RemoteProcessingControlResource;

public class ClusterProcessingControlFactory {
    protected final RemoteInterfaceProvider remoteInterfaceProvider;
    protected final NodeService<ServerNodeDto> nodeService;
    protected final Duration connectionTimeout;
    private final Duration bufferDrainInterval;
    private final int maxBufferDrainRetries;

    @Inject
    public ClusterProcessingControlFactory(RemoteInterfaceProvider remoteInterfaceProvider, NodeService<ServerNodeDto> nodeService, @Named(value="install_http_connection_timeout") Duration connectionTimeout, @Named(value="install_output_buffer_drain_interval") Duration bufferDrainInterval, @Named(value="install_output_buffer_max_retries") int maxBufferDrainRetries) {
        this.remoteInterfaceProvider = remoteInterfaceProvider;
        this.nodeService = nodeService;
        this.connectionTimeout = connectionTimeout;
        this.bufferDrainInterval = bufferDrainInterval;
        this.maxBufferDrainRetries = maxBufferDrainRetries;
    }

    public ClusterProcessingControl<RemoteProcessingControlResource> create(String authorizationToken) {
        return new ClusterProcessingControl<RemoteProcessingControlResource>(authorizationToken, this.remoteInterfaceProvider, this.nodeService, this.connectionTimeout, this.bufferDrainInterval, this.maxBufferDrainRetries);
    }
}

