/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.telemetry.rest.TelemetryService;
import org.graylog2.telemetry.rest.TelemetryUserSettings;

@RequiresAuthentication
@Api(value="Telemetry", description="Message inputs", tags={"cloud"})
@Path(value="/telemetry")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TelemetryResource
extends RestResource {
    private final TelemetryService telemetryService;
    private final AuditEventSender auditEventSender;

    @Inject
    protected TelemetryResource(TelemetryService telemetryService, AuditEventSender auditEventSender) {
        this.telemetryService = telemetryService;
        this.auditEventSender = auditEventSender;
    }

    @GET
    @ApiOperation(value="Get telemetry information.")
    public Map<String, Object> get() {
        return this.telemetryService.getTelemetryResponse(this.getCurrentUserOrThrow());
    }

    @GET
    @Path(value="user/settings")
    @ApiOperation(value="Retrieve a user's telemetry settings.")
    @ApiResponses(value={@ApiResponse(code=404, message="Current user not found.")})
    public TelemetryUserSettings getTelemetryUserSettings() {
        return this.telemetryService.getTelemetryUserSettings(this.getCurrentUserOrThrow());
    }

    @PUT
    @Path(value="user/settings")
    @ApiOperation(value="Update a user's telemetry settings.")
    @ApiResponses(value={@ApiResponse(code=404, message="Current user not found.")})
    @NoAuditEvent(value="Audit event is sent manually.")
    public void saveTelemetryUserSettings(@ApiParam(name="JSON body", value="The telemetry settings to assign to the user.", required=true) @Valid @NotNull TelemetryUserSettings telemetryUserSettings) {
        User currentUser = this.getCurrentUserOrThrow();
        this.telemetryService.saveUserSettings(currentUser, telemetryUserSettings);
        this.auditEventSender.success(AuditActor.user(currentUser.getName()), "server:telemetry_user_settings:update", Map.of("telemetry_enabled", telemetryUserSettings.telemetryEnabled(), "telemetry_permission_asked", telemetryUserSettings.telemetryPermissionAsked()));
    }

    private User getCurrentUserOrThrow() {
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new NotFoundException("Couldn't find current user!");
        }
        return currentUser;
    }
}

