/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.codecs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.aws.cloudwatch.FlowLogMessage;
import org.graylog.integrations.aws.cloudwatch.IANAProtocolNumbers;
import org.graylog.integrations.aws.cloudwatch.KinesisLogEntry;
import org.graylog.integrations.aws.codecs.AbstractKinesisCodec;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class KinesisCloudWatchFlowLogCodec
extends AbstractKinesisCodec {
    public static final String NAME = "FlowLog";
    static final String FIELD_ACCOUNT_ID = "account_id";
    static final String FIELD_INTERFACE_ID = "interface_id";
    static final String FIELD_SRC_ADDR = "src_addr";
    static final String FIELD_DST_ADDR = "dst_addr";
    static final String FIELD_SRC_PORT = "src_port";
    static final String FIELD_DST_PORT = "dst_port";
    static final String FIELD_PROTOCOL_NUMBER = "protocol_number";
    static final String FIELD_PROTOCOL = "protocol";
    static final String FIELD_PACKETS = "packets";
    static final String FIELD_BYTES = "bytes";
    static final String FIELD_CAPTURE_WINDOW_DURATION = "capture_window_duration_seconds";
    static final String FIELD_ACTION = "action";
    static final String FIELD_LOG_STATUS = "log_status";
    static final String SOURCE = "aws-kinesis-flowlogs";
    private static final String FLOW_LOG_PREFIX = "flow_log_";
    private final IANAProtocolNumbers protocolNumbers;
    private final boolean noFlowLogPrefix;
    private final MessageFactory messageFactory;

    @Inject
    public KinesisCloudWatchFlowLogCodec(@Assisted Configuration configuration, ObjectMapper objectMapper, MessageFactory messageFactory) {
        super(configuration, objectMapper);
        this.messageFactory = messageFactory;
        this.protocolNumbers = new IANAProtocolNumbers();
        this.noFlowLogPrefix = configuration.getBoolean("aws_flow_log_prefix", true);
    }

    @Override
    @Nullable
    public Message decodeLogData(@Nonnull KinesisLogEntry logEvent) {
        try {
            FlowLogMessage flowLogMessage = FlowLogMessage.fromLogEvent(logEvent);
            if (flowLogMessage == null) {
                return null;
            }
            String source = this.configuration.getString("override_source", SOURCE);
            Message result = this.messageFactory.createMessage(this.buildSummary(flowLogMessage), source, flowLogMessage.getTimestamp());
            result.addFields(this.buildFields(flowLogMessage));
            result.addField("aws_kinesis_stream", logEvent.kinesisStream());
            result.addField("aws_log_group", logEvent.logGroup());
            result.addField("aws_log_stream", logEvent.logStream());
            result.addField("aws_source", true);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize AWS FlowLog record.", e);
        }
    }

    private String buildSummary(FlowLogMessage msg) {
        return msg.getInterfaceId() + " " + msg.getAction() + " " + this.protocolNumbers.lookup(msg.getProtocolNumber()) + " " + msg.getSourceAddress() + ":" + msg.getSourcePort() + " -> " + msg.getDestinationAddress() + ":" + msg.getDestinationPort();
    }

    private Map<String, Object> buildFields(FlowLogMessage msg) {
        String prefix = this.noFlowLogPrefix ? "" : FLOW_LOG_PREFIX;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(prefix + FIELD_ACCOUNT_ID, msg.getAccountId());
        fields.put(prefix + FIELD_INTERFACE_ID, msg.getInterfaceId());
        fields.put(prefix + FIELD_SRC_ADDR, msg.getSourceAddress());
        fields.put(prefix + FIELD_DST_ADDR, msg.getDestinationAddress());
        fields.put(prefix + FIELD_SRC_PORT, msg.getSourcePort());
        fields.put(prefix + FIELD_DST_PORT, msg.getDestinationPort());
        fields.put(prefix + FIELD_PROTOCOL_NUMBER, msg.getProtocolNumber());
        fields.put(prefix + FIELD_PROTOCOL, this.protocolNumbers.lookup(msg.getProtocolNumber()));
        fields.put(prefix + FIELD_PACKETS, msg.getPackets());
        fields.put(prefix + FIELD_BYTES, msg.getBytes());
        fields.put(prefix + FIELD_CAPTURE_WINDOW_DURATION, Seconds.secondsBetween((ReadableInstant)msg.getCaptureWindowStart(), (ReadableInstant)msg.getCaptureWindowEnd()).getSeconds());
        fields.put(prefix + FIELD_ACTION, msg.getAction());
        fields.put(prefix + FIELD_LOG_STATUS, msg.getLogStatus());
        return fields;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest config = new ConfigurationRequest();
            return config;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<KinesisCloudWatchFlowLogCodec> {
        @Override
        public KinesisCloudWatchFlowLogCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

