/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types.microsoftteams;

import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationException;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfig;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsMessage;
import org.graylog.integrations.notifications.types.util.RequestClient;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamsEventNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(TeamsEventNotification.class);
    private final EventNotificationService notificationCallbackService;
    private final Engine templateEngine;
    private final NotificationService notificationService;
    private final ObjectMapperProvider objectMapperProvider;
    private final NodeId nodeId;
    private final RequestClient requestClient;
    private final URI httpExternalUri;

    @Inject
    public TeamsEventNotification(EventNotificationService notificationCallbackService, ObjectMapperProvider objectMapperProvider, Engine templateEngine, NotificationService notificationService, NodeId nodeId, RequestClient requestClient, HttpConfiguration httpConfiguration) {
        this.notificationCallbackService = notificationCallbackService;
        this.objectMapperProvider = Objects.requireNonNull(objectMapperProvider);
        this.templateEngine = Objects.requireNonNull(templateEngine);
        this.notificationService = Objects.requireNonNull(notificationService);
        this.nodeId = Objects.requireNonNull(nodeId);
        this.requestClient = Objects.requireNonNull(requestClient);
        this.httpExternalUri = httpConfiguration.getHttpExternalUri();
    }

    @Override
    public void execute(EventNotificationContext ctx) throws EventNotificationException {
        TeamsEventNotificationConfig config = (TeamsEventNotificationConfig)ctx.notificationConfig();
        LOG.debug("TeamsEventNotification backlog size in method execute is [{}]", (Object)config.backlogSize());
        try {
            TeamsMessage teamsMessage = this.createTeamsMessage(ctx, config);
            this.requestClient.send(this.objectMapperProvider.getForTimeZone(config.timeZone()).writeValueAsString((Object)teamsMessage), config.webhookUrl());
        }
        catch (TemporaryEventNotificationException exp) {
            throw exp;
        }
        catch (PermanentEventNotificationException exp) {
            String errorMessage = String.format(Locale.ROOT, "Error sending the TeamsEventNotification :: %s", exp.getMessage());
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", "TeamsEventNotification Failed").addDetail("description", errorMessage);
            this.notificationService.publishIfFirst(systemNotification);
            throw exp;
        }
        catch (Exception exp) {
            throw new EventNotificationException("There was an exception triggering the TeamsEventNotification", exp);
        }
    }

    TeamsMessage createTeamsMessage(EventNotificationContext ctx, TeamsEventNotificationConfig config) throws PermanentEventNotificationException {
        String messageTitle = this.buildDefaultMessage(ctx);
        String description = this.buildMessageDescription(ctx);
        String customMessage = null;
        String template = config.customMessage();
        String summary = ctx.eventDefinition().map(EventDefinitionDto::title).orElse("Graylog Event");
        if (!Strings.isNullOrEmpty((String)template)) {
            customMessage = this.buildCustomMessage(ctx, config, template);
        }
        TeamsMessage.Sections section = TeamsMessage.Sections.builder().activityImage(config.iconUrl()).activitySubtitle(description).text(customMessage).build();
        return TeamsMessage.builder().color(config.color()).text(messageTitle).summary(summary).sections(Collections.singleton(section)).build();
    }

    String buildDefaultMessage(EventNotificationContext ctx) {
        String title = ctx.eventDefinition().map(EventDefinitionDto::title).orElse("Unnamed");
        return String.format(Locale.ROOT, "**Alert %s triggered:**\n", title);
    }

    private String buildMessageDescription(EventNotificationContext ctx) {
        String description = ctx.eventDefinition().map(EventDefinitionDto::description).orElse("");
        return "_" + description + "_";
    }

    String buildCustomMessage(EventNotificationContext ctx, TeamsEventNotificationConfig config, String template) throws PermanentEventNotificationException {
        List<MessageSummary> backlog = this.getMessageBacklog(ctx, config);
        Map<String, Object> model = this.getCustomMessageModel(ctx, config.type(), backlog, config.timeZone());
        try {
            return this.templateEngine.transform(template, model);
        }
        catch (Exception e) {
            String error = "Invalid Custom Message template.";
            LOG.error("{} [{}]", (Object)error, (Object)e.toString());
            throw new PermanentEventNotificationException(error + e, e.getCause());
        }
    }

    @VisibleForTesting
    List<MessageSummary> getMessageBacklog(EventNotificationContext ctx, TeamsEventNotificationConfig config) {
        ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
        if (config.backlogSize() > 0L && backlog != null) {
            return backlog.stream().limit(config.backlogSize()).collect(Collectors.toList());
        }
        return backlog;
    }

    @VisibleForTesting
    Map<String, Object> getCustomMessageModel(EventNotificationContext ctx, String type, List<MessageSummary> backlog, DateTimeZone timeZone) {
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        LOG.debug("the custom message model data is {}", (Object)modelData);
        Map objectMap = (Map)this.objectMapperProvider.getForTimeZone(timeZone).convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
        objectMap.put("type", type);
        objectMap.put("http_external_uri", this.httpExternalUri);
        return objectMap;
    }

    public static interface Factory
    extends EventNotification.Factory<TeamsEventNotification> {
        @Override
        public TeamsEventNotification create();
    }
}

