/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.graylog.plugins.map.geoip.IPLocationDatabaseAdapter;
import org.graylog.plugins.map.geoip.IPinfoASN;
import org.graylog.plugins.map.geoip.IPinfoStandardLocation;

public class IPinfoIPLocationDatabaseAdapter
implements IPLocationDatabaseAdapter {
    private final Reader reader;
    private final boolean disableIpInfoDbTypeCheck;

    public IPinfoIPLocationDatabaseAdapter(File databaseFile, boolean disableIpInfoDbTypeCheck) throws IOException {
        this.reader = new Reader(databaseFile, Reader.FileMode.MEMORY_MAPPED, (NodeCache)NoCache.getInstance());
        this.disableIpInfoDbTypeCheck = disableIpInfoDbTypeCheck;
    }

    private <T> T get(InetAddress ipAddress, String type, Class<T> valueClass) throws IOException, AddressNotFoundException {
        String databaseType = this.reader.getMetadata().getDatabaseType();
        if (!(this.disableIpInfoDbTypeCheck || databaseType.contains("ipinfo") && databaseType.contains(type))) {
            String caller = Thread.currentThread().getStackTrace()[2].getMethodName();
            throw new UnsupportedOperationException("Invalid attempt to open a \"" + databaseType + "\" database using the " + caller + " method");
        }
        Object value = this.reader.get(ipAddress, valueClass);
        if (value == null) {
            throw new AddressNotFoundException("Address " + ipAddress.getHostAddress() + " not found in database");
        }
        return (T)value;
    }

    @Override
    public IPinfoStandardLocation ipInfoStandardLocation(InetAddress ipAddress) throws IOException, AddressNotFoundException {
        return this.get(ipAddress, "standard_location", IPinfoStandardLocation.class);
    }

    @Override
    public IPinfoASN ipInfoASN(InetAddress ipAddress) throws IOException, AddressNotFoundException {
        return this.get(ipAddress, "asn", IPinfoASN.class);
    }

    @Override
    public AsnResponse maxMindASN(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public CountryResponse maxMindCountry(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public CityResponse maxMindCity(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

