/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class ListGet
extends AbstractFunction<Object> {
    public static final String NAME = "list_get";
    private static final String LISTARG = "list";
    private static final String IDXARG = "index";
    private final ParameterDescriptor<List, List> listParam = ParameterDescriptor.type("list", List.class).description("A list").build();
    private final ParameterDescriptor<Long, Long> indexParam = ParameterDescriptor.integer("index").ruleBuilderVariable().description("Get the value for this index in list").build();

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        List listValue = this.listParam.required(args, context);
        Long indexValue = this.indexParam.required(args, context);
        if (listValue == null || indexValue == null || indexValue >= (long)listValue.size()) {
            return null;
        }
        return listValue.get(indexValue.intValue());
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Object.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.listParam, this.indexParam)).description("Get a value from a list").ruleBuilderEnabled().ruleBuilderName("Get value from list").ruleBuilderTitle("Get value at index '${index}' from list").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build();
    }
}

