/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.processors.listeners;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.processors.listeners.InterpreterListener;
import org.graylog2.plugin.Message;
import org.graylog2.shared.metrics.MetricUtils;

public class RuleMetricsListener
implements InterpreterListener {
    private final MetricRegistry metricRegistry;
    private final Map<TimerMapKey, Timer.Context> evaluateTimers = new HashMap<TimerMapKey, Timer.Context>();
    private final Map<TimerMapKey, Timer.Context> executeTimers = new HashMap<TimerMapKey, Timer.Context>();

    public RuleMetricsListener(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public static String getMetricName(String name, Type type) {
        return MetricRegistry.name(Rule.class, (String[])new String[]{name, "trace", type.toString().toLowerCase(Locale.US), "duration"});
    }

    private void forEachStage(Rule rule, Pipeline pipeline, Consumer<Stage> consumer) {
        pipeline.stages().forEach(stage -> stage.getRules().stream().filter(stageRule -> Objects.equals(stageRule.id(), rule.id())).forEach(stageRule -> consumer.accept((Stage)stage)));
    }

    private void startTimerForKey(TimerMapKey key, String metricName, Map<TimerMapKey, Timer.Context> timers) {
        Timer timer = MetricUtils.getOrRegister(this.metricRegistry, metricName, new Timer());
        timers.put(key, timer.time());
    }

    private void startTimer(Rule rule, Pipeline pipeline, Type type, Map<TimerMapKey, Timer.Context> timers) {
        if (rule.id() != null && pipeline.id() != null) {
            this.forEachStage(rule, pipeline, stage -> {
                String name = MetricRegistry.name((String)rule.id(), (String[])new String[]{pipeline.id(), String.valueOf(stage.stage())});
                this.startTimerForKey(new TimerMapKey(rule, pipeline, (Stage)stage), RuleMetricsListener.getMetricName(name, type), timers);
            });
            this.startTimerForKey(new TimerMapKey(rule), RuleMetricsListener.getMetricName(rule.id(), type), timers);
        }
    }

    private void stopTimerForKey(TimerMapKey key, Map<TimerMapKey, Timer.Context> timers) {
        Timer.Context timer = timers.get(key);
        if (timer != null) {
            timer.stop();
        }
    }

    private void stopTimer(Rule rule, Pipeline pipeline, Map<TimerMapKey, Timer.Context> timers) {
        if (rule.id() != null && pipeline.id() != null) {
            this.forEachStage(rule, pipeline, stage -> this.stopTimerForKey(new TimerMapKey(rule, pipeline, (Stage)stage), timers));
            this.stopTimerForKey(new TimerMapKey(rule), timers);
        }
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public void processStreams(Message message, Set<Pipeline> pipelines, Set<String> streams) {
    }

    @Override
    public void enterStage(Stage stage) {
    }

    @Override
    public void exitStage(Stage stage) {
    }

    @Override
    public void evaluateRule(Rule rule, Pipeline pipeline) {
        this.startTimer(rule, pipeline, Type.EVALUATE, this.evaluateTimers);
    }

    @Override
    public void failEvaluateRule(Rule rule, Pipeline pipeline) {
        this.stopTimer(rule, pipeline, this.evaluateTimers);
    }

    @Override
    public void satisfyRule(Rule rule, Pipeline pipeline) {
        this.stopTimer(rule, pipeline, this.evaluateTimers);
    }

    @Override
    public void dissatisfyRule(Rule rule, Pipeline pipeline) {
        this.stopTimer(rule, pipeline, this.evaluateTimers);
    }

    @Override
    public void executeRule(Rule rule, Pipeline pipeline) {
        this.startTimer(rule, pipeline, Type.EXECUTE, this.executeTimers);
    }

    @Override
    public void finishExecuteRule(Rule rule, Pipeline pipeline) {
        this.stopTimer(rule, pipeline, this.executeTimers);
    }

    @Override
    public void failExecuteRule(Rule rule, Pipeline pipeline) {
    }

    @Override
    public void continuePipelineExecution(Pipeline pipeline, Stage stage) {
    }

    @Override
    public void stopPipelineExecution(Pipeline pipeline, Stage stage) {
    }

    public static enum Type {
        EXECUTE,
        EVALUATE;

    }

    private static class TimerMapKey {
        private final String rule;
        private final String pipeline;
        private final int stage;

        TimerMapKey(Rule rule) {
            this(rule, null, null);
        }

        TimerMapKey(Rule rule, @Nullable Pipeline pipeline, @Nullable Stage stage) {
            this.rule = rule.id();
            this.pipeline = pipeline != null ? pipeline.id() : null;
            this.stage = stage != null ? stage.stage() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimerMapKey that = (TimerMapKey)o;
            return this.stage == that.stage && this.rule.equals(that.rule) && Objects.equals(this.pipeline, that.pipeline);
        }

        public int hashCode() {
            return Objects.hash(this.rule, this.pipeline, this.stage);
        }
    }
}

