/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.rest.RuleSource;

public class PipelineRuleService {
    private final PipelineRuleParser pipelineRuleParser;

    @Inject
    public PipelineRuleService(PipelineRuleParser pipelineRuleParser) {
        this.pipelineRuleParser = pipelineRuleParser;
    }

    public Rule parseRuleOrThrow(String ruleId, String source, boolean silent) {
        try {
            return this.pipelineRuleParser.parseRule(ruleId, source, silent);
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
    }

    public RuleSource createRuleSourceFromRuleDao(RuleDao ruleDao) {
        return RuleSource.fromDao(this.pipelineRuleParser, ruleDao);
    }
}

