/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.db.migrations;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragmentService;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230915095200_AddSimpleRegex
extends Migration {
    private static final Logger log = LoggerFactory.getLogger(V20230915095200_AddSimpleRegex.class);
    private final RuleFragmentService ruleFragmentService;

    @Inject
    public V20230915095200_AddSimpleRegex(RuleFragmentService ruleFragmentService) {
        this.ruleFragmentService = ruleFragmentService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-09-15T09:52:00Z");
    }

    @Override
    public void upgrade() {
        log.debug("Adding simple regex fragments via migration");
        this.ruleFragmentService.upsert(V20230915095200_AddSimpleRegex.createSimpleRegex());
        log.debug("simple regex fragments were successfully added");
    }

    static RuleFragment createSimpleRegex() {
        String resultvariable = "gl2_fragment_regex_" + System.currentTimeMillis();
        return RuleFragment.builder().fragment("let %resultvar% = regex(\n  pattern: ${pattern},\n  value: ${value}<#if group_names??>,\n  group_names: ${group_names}\n  </#if>\n);".replace("%resultvar%", resultvariable)).descriptor(FunctionDescriptor.builder().name("regex_groups").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.string("pattern", Pattern.class).transform(Pattern::compile).description("The regular expression to match against 'value', uses Java regex syntax").build(), ParameterDescriptor.string("value").ruleBuilderVariable().description("The string to match the pattern against").build(), ParameterDescriptor.type("group_names", List.class).optional().description("List of names to use for matcher groups").build())).returnType(Map.class).description("Match a string with a regular expression (Java syntax) and return matcher groups").ruleBuilderEnabled().ruleBuilderName("Get regex groups").ruleBuilderTitle("Get regex matcher groups for '${pattern}' against '${value}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build()).fragmentOutputVariable(resultvariable).build();
    }
}

