/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.rest;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.graylog2.plugin.Message;

public class RuleBuilderSimulatorResponse {
    private static final String VAR_CONDITION_PREFIX = "gl2_simulator_condition_";
    private static final Pattern OUTPUT_VARIABLE_PATTERN = Pattern.compile("^gl2_simulator_step_(\\d+)_(.*_\\d+)$");
    private final List<Pair<String, Object>> simulatorActionVariables;
    private final Map<String, Object> simulatorConditionVariables;
    @JsonUnwrapped
    private final Message simulatorResult;

    public RuleBuilderSimulatorResponse(Message simulatorResult) {
        this.simulatorResult = simulatorResult;
        this.simulatorConditionVariables = new HashMap<String, Object>();
        this.simulatorActionVariables = new ArrayList<Object>(Collections.nCopies(simulatorResult.getFieldCount(), null));
        simulatorResult.getFields().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(VAR_CONDITION_PREFIX)).forEach(e -> {
            this.simulatorConditionVariables.put(((String)e.getKey()).substring(VAR_CONDITION_PREFIX.length()), e.getValue());
            this.simulatorResult.removeField((String)e.getKey());
        });
        simulatorResult.getFields().entrySet().stream().filter(e -> OUTPUT_VARIABLE_PATTERN.matcher((CharSequence)e.getKey()).matches()).forEach(e -> {
            Matcher matcher = OUTPUT_VARIABLE_PATTERN.matcher((CharSequence)e.getKey());
            matcher.find();
            int actionIndex = Integer.parseInt(matcher.group(1));
            String variableName = matcher.group(2);
            this.simulatorActionVariables.set(actionIndex, (Pair<String, Object>)new ImmutablePair((Object)variableName, e.getValue()));
            this.simulatorResult.removeField((String)e.getKey());
        });
        Iterables.removeIf(this.simulatorActionVariables, (Predicate)Predicates.isNull());
    }

    public List<Pair<String, Object>> getSimulatorActionVariables() {
        return this.simulatorActionVariables;
    }

    public Map<String, Object> getSimulatorConditionVariables() {
        return this.simulatorConditionVariables;
    }
}

