/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.EntityTag;
import java.nio.charset.StandardCharsets;
import org.graylog.plugins.sidecar.common.SidecarPluginConfiguration;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.EtagCacheInvalidation;
import org.graylog.plugins.sidecar.services.SidecarService;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.metrics.CacheStatsSet;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EtagService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(EtagService.class);
    private final Cache<String, Boolean> collectorCache;
    private final Cache<String, Boolean> configurationCache;
    private final Cache<String, String> registrationCache;
    private final MetricRegistry metricRegistry;
    private final EventBus eventBus;
    private final ClusterEventBus clusterEventBus;
    private final ObjectMapper objectMapper;

    @Inject
    public EtagService(SidecarPluginConfiguration pluginConfiguration, MetricRegistry metricRegistry, EventBus eventBus, ClusterEventBus clusterEventBus, ObjectMapperProvider objectMapperProvider) {
        this.metricRegistry = metricRegistry;
        this.eventBus = eventBus;
        this.clusterEventBus = clusterEventBus;
        this.objectMapper = objectMapperProvider.get();
        Duration cacheTime = pluginConfiguration.getCacheTime();
        this.collectorCache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(cacheTime.getQuantity(), cacheTime.getUnit()).maximumSize((long)pluginConfiguration.getCacheMaxSize()).build();
        this.configurationCache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(cacheTime.getQuantity(), cacheTime.getUnit()).maximumSize((long)pluginConfiguration.getCacheMaxSize()).build();
        this.registrationCache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(cacheTime.getQuantity(), cacheTime.getUnit()).maximumSize((long)pluginConfiguration.getCacheMaxSize()).build();
    }

    @Subscribe
    public void handleEtagInvalidation(EtagCacheInvalidation event) {
        Object cache;
        switch (event.cacheContext()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case COLLECTOR: {
                Object object = this.collectorCache;
                break;
            }
            case CONFIGURATION: {
                Object object = this.configurationCache;
                break;
            }
            case REGISTRATION: {
                Object object = cache = this.registrationCache;
            }
        }
        if (event.cacheKey().equals("")) {
            LOG.trace("Invalidating {} cache for all keys", (Object)event.cacheContext());
            cache.invalidateAll();
        } else {
            LOG.trace("Invalidating {} cache for cacheKey {}", (Object)event.cacheContext(), (Object)event.cacheKey());
            cache.invalidate((Object)event.cacheKey());
        }
    }

    public boolean collectorsAreCached(String etag) {
        return this.collectorCache.getIfPresent((Object)etag) != null;
    }

    public boolean configurationsAreCached(String etag) {
        return this.configurationCache.getIfPresent((Object)etag) != null;
    }

    public boolean registrationIsCached(String sidecarNodeId, String etag) {
        return etag.equals(this.registrationCache.getIfPresent((Object)sidecarNodeId));
    }

    public void registerCollector(String etag) {
        this.collectorCache.put((Object)etag, (Object)Boolean.TRUE);
    }

    public void registerConfiguration(String etag) {
        this.configurationCache.put((Object)etag, (Object)Boolean.TRUE);
    }

    public void addSidecarRegistration(String sidecarNodeId, String etag) {
        this.registrationCache.put((Object)sidecarNodeId, (Object)etag);
    }

    public void invalidateAllConfigurations() {
        this.configurationCache.invalidateAll();
        this.clusterEventBus.post(EtagCacheInvalidation.create(CacheContext.CONFIGURATION, ""));
    }

    public void invalidateAllCollectors() {
        this.collectorCache.invalidateAll();
        this.clusterEventBus.post(EtagCacheInvalidation.create(CacheContext.COLLECTOR, ""));
    }

    public void invalidateAllRegistrations() {
        this.registrationCache.invalidateAll();
        this.clusterEventBus.post(EtagCacheInvalidation.create(CacheContext.REGISTRATION, ""));
    }

    public void invalidateRegistration(String sidecarNodeId) {
        this.registrationCache.invalidate((Object)sidecarNodeId);
        this.clusterEventBus.post(EtagCacheInvalidation.create(CacheContext.REGISTRATION, sidecarNodeId));
    }

    public EntityTag buildEntityTagForResponse(Object o) throws JsonProcessingException {
        String json = this.objectMapper.writeValueAsString(o);
        return new EntityTag(Hashing.murmur3_128().hashString((CharSequence)json, StandardCharsets.UTF_8).toString());
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
        MetricUtils.safelyRegisterAll(this.metricRegistry, new CacheStatsSet(MetricRegistry.name(ConfigurationService.class, (String[])new String[]{"etag-cache"}), this.configurationCache));
        MetricUtils.safelyRegisterAll(this.metricRegistry, new CacheStatsSet(MetricRegistry.name(CollectorService.class, (String[])new String[]{"etag-cache"}), this.collectorCache));
        MetricUtils.safelyRegisterAll(this.metricRegistry, new CacheStatsSet(MetricRegistry.name(SidecarService.class, (String[])new String[]{"etag-cache"}), this.registrationCache));
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        this.metricRegistry.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(ConfigurationService.class, (String[])new String[]{"etag-cache"})));
        this.metricRegistry.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(CollectorService.class, (String[])new String[]{"etag-cache"})));
        this.metricRegistry.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(SidecarService.class, (String[])new String[]{"etag-cache"})));
    }

    @JsonAutoDetect
    static enum CacheContext {
        COLLECTOR,
        CONFIGURATION,
        REGISTRATION;

    }
}

