/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.template.loader;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class MongoDbTemplateLoader
implements TemplateLoader {
    private final JacksonDBCollection<Configuration, ObjectId> dbCollection;

    public MongoDbTemplateLoader(JacksonDBCollection<Configuration, ObjectId> dbCollection) {
        this.dbCollection = dbCollection;
    }

    public Object findTemplateSource(String id) throws IOException {
        Configuration configuration;
        try {
            configuration = this.dbCollection.findOne((Bson)DBQuery.is((String)"_id", (Object)this.unlocalize(id)));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (configuration == null) {
            throw new IOException("Can't find template: " + this.unlocalize(id));
        }
        return configuration.template();
    }

    public long getLastModified(Object o) {
        return 0L;
    }

    public Reader getReader(Object snippet, String encoding) {
        return new StringReader((String)snippet);
    }

    public void closeTemplateSource(Object o) {
    }

    private String unlocalize(String s) {
        if (s.contains("_")) {
            return s.substring(0, s.indexOf("_"));
        }
        return s;
    }
}

