/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.SeriesSpec;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AutoValue_Series;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.SeriesConfig;

@AutoValue
public abstract class Series {
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_FUNCTION = "function";
    private static final Pattern destructuringPattern = Pattern.compile("(\\w+)\\(([\\w@-]+)?\\)");

    @JsonProperty(value="config")
    public abstract SeriesConfig config();

    @JsonProperty(value="function")
    public abstract String function();

    public static Builder builder() {
        return new AutoValue_Series.Builder().config(SeriesConfig.empty());
    }

    public static Builder buildFromString(String function) {
        return Series.builder().function(function).config(SeriesConfig.empty());
    }

    public static Series create(String function, String field) {
        return Series.buildFromString(function + "(" + field + ")").build();
    }

    public SeriesSpec toSeriesSpec() {
        Matcher matcher = destructuringPattern.matcher(this.function());
        if (matcher.matches()) {
            String functionName = matcher.group(1);
            String optionalFieldName = matcher.group(2);
            return SeriesSpec.create(functionName, this.function(), optionalFieldName);
        }
        throw new RuntimeException("Unable to parse function: " + this.function());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder config(SeriesConfig var1);

        public abstract Builder function(String var1);

        public abstract Series build();
    }
}

