/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.engine.PositionTrackingQuery;
import org.graylog.plugins.views.search.engine.QueryStringDecorator;

public class QueryStringDecorators {
    private final Optional<QueryStringDecorator> decorator;

    @Inject
    public QueryStringDecorators(Optional<QueryStringDecorator> queryDecorators) {
        this.decorator = queryDecorators;
    }

    public String decorate(String queryString, ParameterProvider job, Query query) {
        return this.decorateWithPositions(queryString, job, query).getInterpolatedQuery();
    }

    public String decorate(String queryString, ParameterProvider params) {
        Query dummyQuery = Query.builder().query(ElasticsearchQueryString.of(queryString)).build();
        return this.decorateWithPositions(queryString, params, dummyQuery).getInterpolatedQuery();
    }

    public PositionTrackingQuery decorateWithPositions(String queryString, ParameterProvider job, Query query) {
        return this.decorator.map(decorator -> decorator.decorate(queryString, job, query)).orElseGet(() -> PositionTrackingQuery.of(queryString));
    }
}

