/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.normalization;

import com.google.common.base.MoreObjects;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.engine.normalization.PostValidation;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalization;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalizer;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;

public class PluggableSearchNormalization
implements SearchNormalization {
    private final Set<SearchNormalizer> pluggableNormalizers;
    private final Set<SearchNormalizer> postValidationNormalizers;

    @Inject
    public PluggableSearchNormalization(Set<SearchNormalizer> pluggableNormalizers, @PostValidation Set<SearchNormalizer> postValidationNormalizers) {
        this.pluggableNormalizers = pluggableNormalizers;
        this.postValidationNormalizers = postValidationNormalizers;
    }

    public PluggableSearchNormalization(Set<SearchNormalizer> pluggableNormalizers) {
        this(pluggableNormalizers, Collections.emptySet());
    }

    private Search normalize(Search search, Set<SearchNormalizer> normalizers) {
        Search normalizedSearch = search;
        for (SearchNormalizer searchNormalizer : normalizers) {
            normalizedSearch = searchNormalizer.normalize(normalizedSearch);
        }
        return normalizedSearch;
    }

    private Query normalize(Query query, ParameterProvider parameterProvider, Set<SearchNormalizer> normalizers) {
        Query normalizedQuery = query;
        for (SearchNormalizer searchNormalizer : normalizers) {
            normalizedQuery = searchNormalizer.normalizeQuery(normalizedQuery, parameterProvider);
        }
        return normalizedQuery;
    }

    @Override
    public Search preValidation(Search search, SearchUser searchUser, ExecutionState executionState) {
        Search searchWithStreams = search.addStreamsToQueriesWithoutStreams(() -> searchUser.streams().loadMessageStreamsWithFallback());
        Search normalizedSearch = searchWithStreams.applyExecutionState((ExecutionState)MoreObjects.firstNonNull((Object)executionState, (Object)ExecutionState.empty()));
        return this.normalize(normalizedSearch, this.pluggableNormalizers);
    }

    @Override
    public Search postValidation(Search search, SearchUser searchUser, ExecutionState executionState) {
        return this.normalize(search, this.postValidationNormalizers);
    }

    @Override
    public Query preValidation(Query query, ParameterProvider parameterProvider, SearchUser searchUser, ExecutionState executionState) {
        Query normalizedQuery = query;
        if (!query.hasStreams()) {
            normalizedQuery = query.addStreamsToFilter((Set<String>)searchUser.streams().loadMessageStreamsWithFallback());
        }
        if (!executionState.equals(ExecutionState.empty())) {
            normalizedQuery = normalizedQuery.applyExecutionState(executionState);
        }
        return this.normalize(normalizedQuery, parameterProvider, this.pluggableNormalizers);
    }

    @Override
    public Query postValidation(Query query, ParameterProvider parameterProvider) {
        return this.normalize(query, parameterProvider, this.postValidationNormalizers);
    }
}

