/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.export.ExportJob;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class ExportJobService {
    protected final JacksonDBCollection<ExportJob, ObjectId> db;

    @Inject
    public ExportJobService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection("export_jobs"), ExportJob.class, ObjectId.class, mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("created_at", (Object)1), (DBObject)new BasicDBObject("expireAfterSeconds", (Object)TimeUnit.HOURS.toSeconds(1L)));
    }

    public Optional<ExportJob> get(String id) {
        if (!ObjectId.isValid((String)id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.db.findOneById(new ObjectId(id)));
    }

    public String save(ExportJob exportJob) {
        WriteResult<ExportJob, ObjectId> save = this.db.insert(exportJob);
        return save.getSavedId().toHexString();
    }
}

