/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation.validators;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.queryparser.classic.ParseException;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.engine.PositionTrackingQuery;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.errors.MissingEnterpriseLicenseException;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.validation.FieldTypeValidation;
import org.graylog.plugins.views.search.validation.LuceneQueryParser;
import org.graylog.plugins.views.search.validation.ParsedQuery;
import org.graylog.plugins.views.search.validation.ParsedTerm;
import org.graylog.plugins.views.search.validation.QueryValidator;
import org.graylog.plugins.views.search.validation.ValidationContext;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationMode;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.validators.ValidationErrors;
import org.graylog2.indexer.fieldtypes.FieldTypes;

public class FieldValueTypeValidator
implements QueryValidator {
    private final FieldTypeValidation fieldTypeValidation;
    private final LuceneQueryParser luceneQueryParser;
    private final QueryStringDecorators queryStringDecorators;

    @Inject
    public FieldValueTypeValidator(FieldTypeValidation fieldTypeValidation, LuceneQueryParser luceneQueryParser, QueryStringDecorators queryStringDecorators) {
        this.fieldTypeValidation = fieldTypeValidation;
        this.luceneQueryParser = luceneQueryParser;
        this.queryStringDecorators = queryStringDecorators;
    }

    @Override
    public List<ValidationMessage> validate(ValidationContext context) {
        try {
            PositionTrackingQuery decorated = this.decoratedQuery(context.request());
            return this.validateQueryValues(decorated, context.availableFields());
        }
        catch (ParseException e) {
            return ValidationErrors.create((Exception)((Object)e));
        }
        catch (SearchException e) {
            return this.ignoreForSearchFilters(ValidationErrors.create(e), context);
        }
        catch (MissingEnterpriseLicenseException e) {
            return this.ignoreForSearchFilters(ValidationErrors.create(e), context);
        }
    }

    private List<ValidationMessage> ignoreForSearchFilters(List<ValidationMessage> validationMessages, ValidationContext context) {
        if (context.request().validationMode() == ValidationMode.SEARCH_FILTER) {
            return Collections.emptyList();
        }
        return validationMessages;
    }

    private PositionTrackingQuery decoratedQuery(ValidationRequest req) {
        ParameterProvider parameterProvider = name -> req.parameters().stream().filter(p -> Objects.equals(p.name(), name)).findFirst();
        Query query = Query.builder().query(req.query()).timerange(req.timerange()).build();
        return this.queryStringDecorators.decorateWithPositions(req.getCombinedQueryWithFilter(), parameterProvider, query);
    }

    private List<ValidationMessage> validateQueryValues(PositionTrackingQuery decorated, Set<MappedFieldTypeDTO> availableFields) throws ParseException {
        ParsedQuery parsedQuery = this.luceneQueryParser.parse(decorated.getInterpolatedQuery());
        Map fields = availableFields.stream().collect(Collectors.toMap(MappedFieldTypeDTO::name, Function.identity()));
        return parsedQuery.terms().stream().filter(term -> !term.isExistsField()).map(term -> {
            MappedFieldTypeDTO fieldType = (MappedFieldTypeDTO)fields.get(term.getRealFieldName());
            Optional<String> typeName = Optional.ofNullable(fieldType).map(MappedFieldTypeDTO::type).map(FieldTypes.Type::type);
            return typeName.flatMap(type -> this.fieldTypeValidation.validateFieldValueType((ParsedTerm)term, (String)type)).map(validation -> validation.position().map(decorated::backtrackPosition).map(backtrackedPosition -> validation.toBuilder().position((QueryPosition)backtrackedPosition).build()).orElse((ValidationMessage)validation));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

