/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.views.$AutoValue_ViewSummaryDTO;
import org.graylog.plugins.views.search.views.MongoIgnore;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewLike;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class ViewSummaryDTO
implements ViewLike {
    @Override
    @ObjectId
    @Id
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @Override
    @JsonProperty(value="type")
    public abstract ViewDTO.Type type();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="summary")
    public abstract String summary();

    @JsonProperty(value="description")
    public abstract String description();

    @JsonProperty(value="search_id")
    public abstract String searchId();

    @JsonProperty(value="properties")
    public abstract ImmutableSet<String> properties();

    @JsonProperty(value="requires")
    public abstract Map<String, PluginMetadataSummary> requires();

    @JsonProperty(value="owner")
    public abstract Optional<String> owner();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    @JsonProperty(value="favorite")
    @MongoIgnore
    public abstract boolean favorite();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public static Set<String> idsFrom(Collection<ViewSummaryDTO> views) {
        return views.stream().map(ViewSummaryDTO::id).collect(Collectors.toSet());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @AutoValue.Builder
    public static abstract class Builder {
        @ObjectId
        @Id
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(ViewDTO.Type var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="summary")
        public abstract Builder summary(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="search_id")
        public abstract Builder searchId(String var1);

        abstract ImmutableSet.Builder<String> propertiesBuilder();

        @JsonProperty(value="properties")
        public Builder properties(Set<String> properties) {
            this.propertiesBuilder().addAll(properties);
            return this;
        }

        @JsonProperty(value="requires")
        public abstract Builder requires(Map<String, PluginMetadataSummary> var1);

        @JsonProperty(value="owner")
        public abstract Builder owner(@Nullable String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        @JsonProperty(value="favorite")
        @MongoIgnore
        public abstract Builder favorite(boolean var1);

        @JsonCreator
        public static Builder create() {
            return new $AutoValue_ViewSummaryDTO.Builder().type(ViewDTO.Type.DASHBOARD).summary("").description("").properties((Set<String>)ImmutableSet.of()).requires(Collections.emptyMap()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).favorite(false);
        }

        public abstract ViewSummaryDTO build();
    }
}

