/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.graylog.scheduler.JobSchedulerConfig;
import org.graylog.scheduler.JobSchedulerConfiguration;
import org.graylog2.cluster.leader.LeaderElectionService;

@Singleton
public class DefaultJobSchedulerConfig
implements JobSchedulerConfig {
    private final LeaderElectionService leaderElectionService;
    private final JobSchedulerConfiguration config;

    @Inject
    public DefaultJobSchedulerConfig(LeaderElectionService leaderElectionService, JobSchedulerConfiguration config) {
        this.leaderElectionService = leaderElectionService;
        this.config = config;
    }

    @Override
    public boolean canExecute() {
        return this.leaderElectionService.isLeader();
    }

    @Override
    public int numberOfWorkerThreads() {
        return 5;
    }

    @Override
    public Map<String, Integer> concurrencyLimits() {
        return ImmutableMap.copyOf(this.config.getConcurrencyLimits());
    }
}

