/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.ca;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.ca.exceptions.CACreationException;

public class CAKeyPair {
    private final KeyStore keystore;

    private CAKeyPair(String organization, char[] password, Duration certificateValidity) throws CACreationException {
        try {
            KeyPair rootCA = CertificateGenerator.generate(CertRequest.selfSigned(organization).isCA(true).validity(certificateValidity));
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(null, null);
            caKeystore.setKeyEntry("ca", rootCA.privateKey(), password, new X509Certificate[]{rootCA.certificate()});
            this.keystore = caKeystore;
        }
        catch (Exception e) {
            throw new CACreationException("Failed to create a Certificate Authority", e);
        }
    }

    public static CAKeyPair create(String organization, char[] password, Duration certificateValidity) throws CACreationException {
        return new CAKeyPair(organization, password, certificateValidity);
    }

    public KeyStore toKeyStore() {
        return this.keystore;
    }
}

