/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import io.swagger.annotations.Api;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;

@Api(value="Certificate Provisioning for data node")
@Path(value="/datanode/provision")
@Produces(value={"application/json"})
@RequiresAuthentication
public class DataNodeProvisioningResource {
    private final NodeService<DataNodeDto> nodeService;
    private final DataNodeProvisioningService dataNodeProvisioningService;

    @Inject
    public DataNodeProvisioningResource(NodeService<DataNodeDto> nodeService, DataNodeProvisioningService dataNodeProvisioningService) {
        this.nodeService = nodeService;
        this.dataNodeProvisioningService = dataNodeProvisioningService;
    }

    @POST
    @Path(value="/generate")
    @NoAuditEvent(value="No Audit Event needed")
    public void generate() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        activeDataNodes.values().forEach(node -> this.dataNodeProvisioningService.changeState(node.getNodeId(), DataNodeProvisioningConfig.State.CONFIGURED));
    }
}

